/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoCreateDeadLetterResourcesTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString dla = SimpleString.of((String)"myDLA");
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(100L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateDeadLetterResources(true).setDeadLetterAddress(this.dla).setMaxDeliveryAttempts(1));
        this.server.start();
    }

    @Test
    public void testAutoCreationOfDeadLetterResources() throws Exception {
        int before = this.server.getActiveMQServerControl().getQueueNames().length;
        this.triggerDlaDelivery();
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.dla));
        Assertions.assertNotNull((Object)this.server.locateQueue(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX)));
        Assertions.assertEquals((int)2, (int)(this.server.getActiveMQServerControl().getQueueNames().length - before));
    }

    @Test
    public void testAutoCreationOfDeadLetterResourcesWithNullDLA() throws Exception {
        this.testAutoCreationOfDeadLetterResourcesWithNoDLA(null);
    }

    @Test
    public void testAutoCreationOfDeadLetterResourcesWithEmptyDLA() throws Exception {
        this.testAutoCreationOfDeadLetterResourcesWithNoDLA(SimpleString.of((String)""));
    }

    private void testAutoCreationOfDeadLetterResourcesWithNoDLA(SimpleString dla) throws Exception {
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setDeadLetterAddress(dla);
        int before = this.server.getActiveMQServerControl().getQueueNames().length;
        this.triggerDlaDelivery();
        if (dla != null) {
            Assertions.assertNull((Object)this.server.getAddressInfo(dla));
        }
        Assertions.assertNull((Object)this.server.locateQueue(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX)));
        Assertions.assertEquals((int)1, (int)(this.server.getActiveMQServerControl().getQueueNames().length - before));
    }

    @Test
    public void testAutoCreateDeadLetterQueuePrefix() throws Exception {
        SimpleString prefix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setDeadLetterQueuePrefix(prefix);
        this.triggerDlaDelivery();
        Assertions.assertNotNull((Object)this.server.locateQueue(prefix.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX)));
    }

    @Test
    public void testAutoCreateDeadLetterQueueSuffix() throws Exception {
        SimpleString suffix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setDeadLetterQueueSuffix(suffix);
        this.triggerDlaDelivery();
        Assertions.assertNotNull((Object)this.server.locateQueue(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(suffix)));
    }

    @Test
    public void testAutoCreateDeadLetterQueuePrefixAndSuffix() throws Exception {
        SimpleString prefix = RandomUtil.randomSimpleString();
        SimpleString suffix = RandomUtil.randomSimpleString();
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("#")).setDeadLetterQueuePrefix(prefix).setDeadLetterQueueSuffix(suffix);
        this.triggerDlaDelivery();
        Assertions.assertNotNull((Object)this.server.locateQueue(prefix.concat(this.addressA).concat(suffix)));
    }

    @Test
    public void testAutoCreatedDeadLetterFilterAnycast() throws Exception {
        this.testAutoCreatedDeadLetterFilter(RoutingType.ANYCAST);
    }

    @Test
    public void testAutoCreatedDeadLetterFilterMulticast() throws Exception {
        this.testAutoCreatedDeadLetterFilter(RoutingType.MULTICAST);
    }

    private void testAutoCreatedDeadLetterFilter(RoutingType routingType) throws Exception {
        int ITERATIONS = 100;
        int MESSAGE_COUNT = 10;
        for (int i = 0; i < 100; ++i) {
            SimpleString address = RandomUtil.randomSimpleString();
            SimpleString queue = RandomUtil.randomSimpleString();
            this.server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setRoutingType(routingType));
            ServerLocator locator = this.createInVMNonHALocator();
            ClientSessionFactory cf = this.createSessionFactory(locator);
            ClientSession s = this.addClientSession(cf.createSession(true, false));
            ClientProducer p = s.createProducer(address);
            for (int j = 0; j < 10; ++j) {
                p.send(s.createMessage(true).setRoutingType(routingType));
            }
            p.close();
            ClientConsumer consumer = s.createConsumer(queue);
            s.start();
            for (int j = 0; j < 10; ++j) {
                ClientMessage message = consumer.receive();
                Assertions.assertNotNull((Object)message);
                message.acknowledge();
            }
            s.rollback();
            Queue dlq = this.server.locateQueue(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(address).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX));
            Assertions.assertNotNull((Object)dlq);
            Wait.assertEquals((long)10L, () -> ((Queue)dlq).getMessageCount());
        }
        Assertions.assertEquals((int)100, (int)this.server.getPostOffice().getBindingsForAddress(this.dla).getBindings().size());
    }

    @Test
    public void testAutoDeletionAndRecreationOfDeadLetterResources() throws Exception {
        SimpleString dlqName = AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
        this.triggerDlaDelivery();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, true));
        ClientConsumer consumer = session.createConsumer(dlqName);
        session.start();
        ClientMessage message = consumer.receive();
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        session.close();
        sessionFactory.close();
        locator.close();
        Wait.assertTrue(() -> this.server.locateQueue(dlqName) == null, (long)2000L, (long)100L);
        this.server.destroyQueue(this.queueA);
        this.triggerDlaDelivery();
        Assertions.assertNotNull((Object)this.server.getAddressInfo(this.dla));
        Assertions.assertNotNull((Object)this.server.locateQueue(dlqName));
    }

    @Test
    public void testWithJMSFQQN() throws Exception {
        SimpleString dlqName = AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
        String fqqn = CompositeAddress.toFullyQualified((SimpleString)this.dla, (SimpleString)dlqName).toString();
        this.triggerDlaDelivery();
        JMSContext context = new ActiveMQConnectionFactory("vm://0").createContext();
        context.start();
        Assertions.assertNotNull((Object)context.createConsumer((Destination)context.createQueue(fqqn)).receive(2000L));
    }

    @Test
    public void testDivertedMessage() throws Exception {
        SimpleString dlqName = AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
        String divertAddress = "divertAddress";
        this.server.deployDivert(new DivertConfiguration().setName("testDivert").setAddress(divertAddress).setForwardingAddress(this.addressA.toString()));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer(divertAddress));
        producer.send((Message)session.createMessage(true));
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.server.locateQueue(this.queueA).getMessageCount(), (long)2000L, (long)100L);
        this.triggerDlaDelivery();
        Wait.assertTrue(() -> this.server.locateQueue(dlqName).getMessageCount() == 1L, (long)2000L, (long)100L);
        ClientConsumer consumer = session.createConsumer(dlqName);
        session.start();
        ClientMessage message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
    }

    @Test
    public void testMovedMessage() throws Exception {
        SimpleString dlqName = AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
        SimpleString moveFromAddress = SimpleString.of((String)"moveFromAddress");
        SimpleString moveFromQueue = SimpleString.of((String)"moveFromQueue");
        this.server.createQueue(QueueConfiguration.of((SimpleString)moveFromQueue).setAddress(moveFromAddress).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer(moveFromAddress));
        producer.send((Message)session.createMessage(true));
        producer.close();
        Wait.assertEquals((Long)1L, () -> ((Queue)this.server.locateQueue(moveFromQueue)).getMessageCount(), (long)2000L, (long)100L);
        this.server.locateQueue(moveFromQueue).moveReferences(null, this.addressA, null);
        Wait.assertEquals((Long)1L, () -> ((Queue)this.server.locateQueue(this.queueA)).getMessageCount(), (long)2000L, (long)100L);
        this.triggerDlaDelivery();
        Wait.assertEquals((Long)1L, () -> ((Queue)this.server.locateQueue(dlqName)).getMessageCount(), (long)2000L, (long)100L);
        ClientConsumer consumer = session.createConsumer(dlqName);
        session.start();
        ClientMessage message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
    }

    @Test
    public void testOngoingSendToDLAPreventAutoDelete() throws Exception {
        int messageCount = 100;
        SimpleString dlqName = AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX.concat(this.addressA).concat(AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX);
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, true));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.addressA));
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(AutoCreateDeadLetterResourcesTest.createFakeLargeStream(0x100000L).readAllBytes());
        for (int i = 0; i < 100; ++i) {
            producer.send((Message)message);
        }
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue." + this.queueA);
        queueControl.sendMessagesToDeadLetterAddress(null);
        QueueControl dlqControl = (QueueControl)this.server.getManagementService().getResource("queue." + dlqName);
        dlqControl.retryMessages();
        for (int i = 0; i < 10; ++i) {
            queueControl.sendMessagesToDeadLetterAddress(null);
            dlqControl.retryMessages();
        }
        Wait.assertTrue(() -> queueControl.getMessageCount() == 100L, (long)2000L);
        Wait.assertTrue(() -> this.server.locateQueue(dlqName) == null, (long)2000L);
    }

    private void triggerDlaDelivery() throws Exception {
        try {
            this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(sessionFactory.createSession(true, false));
        ClientProducer producer = this.addClientProducer(session.createProducer(this.addressA));
        producer.send((Message)session.createMessage(true));
        producer.close();
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer(this.queueA));
        session.start();
        ClientMessage message = consumer.receive();
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        session.rollback();
        session.close();
        sessionFactory.close();
        locator.close();
    }
}

