/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.util;

import java.util.StringTokenizer;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrameV10;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompFrameFactory;

public class StompFrameFactoryV10
implements StompFrameFactory {
    @Override
    public ClientStompFrame createFrame(String data) {
        String[] dataFields = data.split("\n\n");
        StringTokenizer tokenizer = new StringTokenizer(dataFields[0], "\n");
        String command = tokenizer.nextToken();
        ClientStompFrame frame = this.newFrame(command);
        while (tokenizer.hasMoreTokens()) {
            String header = tokenizer.nextToken();
            String[] fields = this.handleHeaders(header);
            frame.addHeader(fields[0], fields[1]);
        }
        if (dataFields.length == 2) {
            frame.setBody(dataFields[1]);
        }
        return frame;
    }

    @Override
    public String[] handleHeaders(String header) {
        String[] result = header.split(":");
        if (result.length == 1) {
            String[] tmp = new String[]{result[0], ""};
            result = tmp;
        }
        return result;
    }

    @Override
    public ClientStompFrame newFrame(String command) {
        return new ClientStompFrameV10(command);
    }

    @Override
    public ClientStompFrame newAnyFrame(String command) {
        return new ClientStompFrameV10(command, false);
    }
}

