/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.SimpleManagement;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.util.ServerUtil;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealServerTestBase
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String STOP_FILE_NAME = "STOP_ME";
    Set<Process> processes = new HashSet<Process>();
    private static final String JMX_SERVER_HOSTNAME = "localhost";
    private static final int JMX_SERVER_PORT = 10099;
    public static final String basedir = System.getProperty("basedir");

    @AfterEach
    public void after() throws Exception {
        this.closeAllServerLocatorsFactories();
        for (Process process : this.processes) {
            try {
                ServerUtil.killServer((Process)process, (boolean)true);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.processes.clear();
    }

    public void killServer(Process process) {
        this.processes.remove(process);
        try {
            ServerUtil.killServer((Process)process);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected static void stopServerWithFile(String serverLocation) throws IOException {
        File serverPlace = new File(serverLocation);
        File etcPlace = new File(serverPlace, "etc");
        File stopMe = new File(etcPlace, STOP_FILE_NAME);
        Assertions.assertTrue((boolean)stopMe.createNewFile());
    }

    protected static void stopServerWithFile(String serverLocation, Process process, int timeout, TimeUnit unit) throws Exception {
        RealServerTestBase.stopServerWithFile(serverLocation);
        process.waitFor(timeout, unit);
    }

    public static String getServerLocation(String serverName) {
        return basedir + "/target/" + serverName;
    }

    public static File getFileServerLocation(String serverName) {
        return new File(RealServerTestBase.getServerLocation(serverName));
    }

    public static boolean cleanupData(String serverName) {
        String location = RealServerTestBase.getServerLocation(serverName);
        boolean result = RealServerTestBase.deleteDirectory(new File(location, "data"));
        RealServerTestBase.deleteDirectory(new File(location, "log"));
        return result;
    }

    public void addProcess(Process process) {
        this.processes.add(process);
    }

    public void removeProcess(Process process) {
        this.processes.remove(process);
    }

    public Process startServer(String serverName, int portID, int timeout) throws Exception {
        return this.startServer(serverName, portID, timeout, null);
    }

    public Process startServer(String serverName, int portID, int timeout, File brokerProperties) throws Exception {
        Process process = ServerUtil.startServer((String)RealServerTestBase.getServerLocation(serverName), (String)serverName, (int)portID, (int)timeout, (File)brokerProperties);
        this.addProcess(process);
        return process;
    }

    public Process startServer(String serverName, String uri, int timeout) throws Exception {
        Process process = ServerUtil.startServer((String)RealServerTestBase.getServerLocation(serverName), (String)serverName, (String)uri, (int)timeout);
        this.addProcess(process);
        return process;
    }

    protected JMXConnector getJmxConnector() throws MalformedURLException {
        return RealServerTestBase.getJmxConnector(JMX_SERVER_HOSTNAME, 10099);
    }

    protected static JMXConnector newJMXFactory(String uri) throws Throwable {
        return JMXConnectorFactory.connect(new JMXServiceURL(uri));
    }

    protected static ActiveMQServerControl getServerControl(String uri, ObjectNameBuilder builder, long timeout) throws Throwable {
        long expireLoop = System.currentTimeMillis() + timeout;
        Throwable lastException = null;
        while (true) {
            try {
                JMXConnector connector = RealServerTestBase.newJMXFactory(uri);
                ActiveMQServerControl serverControl = MBeanServerInvocationHandler.newProxyInstance(connector.getMBeanServerConnection(), builder.getActiveMQServerObjectName(), ActiveMQServerControl.class, false);
                serverControl.isActive();
                return serverControl;
            }
            catch (Throwable e) {
                lastException = e;
                Thread.sleep(500L);
                if (expireLoop > System.currentTimeMillis()) continue;
                throw lastException;
            }
            break;
        }
    }

    protected static JMXConnector getJmxConnector(String hostname, int port) throws MalformedURLException {
        System.setProperty("java.rmi.server.hostname", hostname);
        String urlString = "service:jmx:rmi:///jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        JMXServiceURL url = new JMXServiceURL(urlString);
        JMXConnector jmxConnector = null;
        try {
            jmxConnector = JMXConnectorFactory.connect(url);
            System.out.println("Successfully connected to: " + urlString);
        }
        catch (Exception e) {
            jmxConnector = null;
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
        return jmxConnector;
    }

    protected static final void recreateBrokerDirectory(String homeInstance) {
        RealServerTestBase.recreateDirectory(homeInstance + "/data");
        RealServerTestBase.recreateDirectory(homeInstance + "/log");
    }

    protected boolean findLogRecord(File logFile, String ... values) throws Exception {
        Assertions.assertTrue((boolean)logFile.exists());
        boolean hasRecord = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String line = reader.readLine();
            while (line != null) {
                if (line.contains(values[0])) {
                    boolean hasAll = true;
                    for (int i = 1; i < values.length; ++i) {
                        if (line.contains(values[i])) continue;
                        hasAll = false;
                        break;
                    }
                    if (hasAll) {
                        hasRecord = true;
                        logger.debug("audit found: {}", (Object)line);
                        break;
                    }
                }
                line = reader.readLine();
            }
            boolean bl = hasRecord;
            return bl;
        }
    }

    protected static QueueControl getQueueControl(String uri, ObjectNameBuilder builder, String address, String queueName, RoutingType routingType, long timeout) throws Throwable {
        long expireLoop = System.currentTimeMillis() + timeout;
        Throwable lastException = null;
        while (true) {
            try {
                JMXConnector connector = RealServerTestBase.newJMXFactory(uri);
                ObjectName objectQueueName = builder.getQueueObjectName(SimpleString.of((String)address), SimpleString.of((String)queueName), routingType);
                QueueControl queueControl = MBeanServerInvocationHandler.newProxyInstance(connector.getMBeanServerConnection(), objectQueueName, QueueControl.class, false);
                queueControl.getMessagesAcknowledged();
                return queueControl;
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                lastException = e;
                Thread.sleep(500L);
                if (expireLoop > System.currentTimeMillis()) continue;
                throw lastException;
            }
            break;
        }
    }

    protected static void unzip(File zipFile, File serverFolder) throws IOException, ClassNotFoundException, InterruptedException {
        ProcessBuilder zipBuilder = new ProcessBuilder("unzip", zipFile.getAbsolutePath()).directory(serverFolder);
        Process process = zipBuilder.start();
        SpawnedVMSupport.startLogger((String)"zip", (Process)process);
        logger.info("Zip finished with {}", (Object)process.waitFor());
    }

    protected static void zip(File zipFile, File serverFolder) throws IOException, ClassNotFoundException, InterruptedException {
        logger.info("Zipping data folder for {}", (Object)zipFile);
        ProcessBuilder zipBuilder = new ProcessBuilder("zip", "-r", zipFile.getAbsolutePath(), "data").directory(serverFolder);
        Process process = zipBuilder.start();
        SpawnedVMSupport.startLogger((String)"zip", (Process)process);
        logger.info("Zip finished with {}", (Object)process.waitFor());
    }

    public boolean waitForServerToStart(String uri, String username, String password, long timeout) throws InterruptedException {
        long realTimeout = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < realTimeout) {
            try (ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)uri, null);){
                cf.createConnection(username, password).close();
                System.out.println("server " + uri + " started");
            }
            catch (Exception e) {
                System.out.println("awaiting server " + uri + " start at ");
                Thread.sleep(500L);
                continue;
            }
            return true;
        }
        return false;
    }

    protected static void saveProperties(Properties properties, File propertiesFile) throws Exception {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(propertiesFile));
        properties.store(outputStream, "# Broker properties");
        ((OutputStream)outputStream).close();
    }

    protected long getMessageCount(String uri, String queueName) throws Exception {
        SimpleManagement management = new SimpleManagement(uri, null, null);
        return this.getMessageCount(management, queueName);
    }

    protected long getMessageCount(SimpleManagement simpleManagement, String queue) throws Exception {
        try {
            long value = simpleManagement.getMessageCountOnQueue(queue);
            logger.info("count on queue {} is {}", (Object)queue, (Object)value);
            return value;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }
}

