/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpTransactionCoordinator;
import org.apache.activemq.transport.amqp.client.AmqpTransactionId;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.activemq.transport.amqp.client.util.ClientFuture;
import org.apache.activemq.transport.amqp.client.util.ClientFutureSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionContext {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AmqpSession session;
    private final Set<AmqpReceiver> txReceivers = new LinkedHashSet<AmqpReceiver>();
    private AmqpTransactionCoordinator coordinator;
    private AmqpTransactionId transactionId;

    public AmqpTransactionContext(AmqpSession session) {
        this.session = session;
    }

    public void begin() throws Exception {
        if (this.transactionId != null) {
            throw new IOException("Begin called while a TX is still Active.");
        }
        final AmqpTransactionId txId = this.session.getConnection().getNextTransactionId();
        final ClientFuture request = new ClientFuture(new ClientFutureSynchronization(){

            @Override
            public void onPendingSuccess() {
                AmqpTransactionContext.this.transactionId = txId;
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                AmqpTransactionContext.this.transactionId = null;
            }
        });
        logger.info("Attempting to Begin TX:[{}]", (Object)txId);
        this.session.getScheduler().execute(() -> {
            if (this.coordinator == null || this.coordinator.isClosed()) {
                logger.info("Creating new Coordinator for TX:[{}]", (Object)txId);
                this.coordinator = new AmqpTransactionCoordinator(this.session);
                this.coordinator.open(new AsyncResult(){

                    @Override
                    public void onSuccess() {
                        try {
                            logger.info("Attempting to declare TX:[{}]", (Object)txId);
                            AmqpTransactionContext.this.coordinator.declare(txId, request);
                        }
                        catch (Exception e) {
                            request.onFailure(e);
                        }
                    }

                    @Override
                    public void onFailure(Throwable result) {
                        request.onFailure(result);
                    }

                    @Override
                    public boolean isComplete() {
                        return request.isComplete();
                    }
                });
            } else {
                try {
                    logger.info("Attempting to declare TX:[{}]", (Object)txId);
                    this.coordinator.declare(txId, request);
                }
                catch (Exception e) {
                    request.onFailure(e);
                }
            }
            this.session.pumpToProtonTransport(request);
        });
        request.sync();
    }

    public void commit() throws Exception {
        if (this.transactionId == null) {
            throw new IllegalStateException("Commit called with no active Transaction.");
        }
        this.preCommit();
        ClientFuture request = new ClientFuture(new ClientFutureSynchronization(){

            @Override
            public void onPendingSuccess() {
                AmqpTransactionContext.this.transactionId = null;
                AmqpTransactionContext.this.postCommit();
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                AmqpTransactionContext.this.transactionId = null;
                AmqpTransactionContext.this.postCommit();
            }
        });
        logger.debug("Commit on TX[{}] initiated", (Object)this.transactionId);
        this.session.getScheduler().execute(() -> {
            try {
                logger.info("Attempting to commit TX:[{}]", (Object)this.transactionId);
                this.coordinator.discharge(this.transactionId, request, true);
                this.session.pumpToProtonTransport(request);
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public void rollback() throws Exception {
        if (this.transactionId == null) {
            throw new IllegalStateException("Rollback called with no active Transaction.");
        }
        this.preRollback();
        ClientFuture request = new ClientFuture(new ClientFutureSynchronization(){

            @Override
            public void onPendingSuccess() {
                AmqpTransactionContext.this.transactionId = null;
                AmqpTransactionContext.this.postRollback();
            }

            @Override
            public void onPendingFailure(Throwable cause) {
                AmqpTransactionContext.this.transactionId = null;
                AmqpTransactionContext.this.postRollback();
            }
        });
        logger.debug("Rollback on TX[{}] initiated", (Object)this.transactionId);
        this.session.getScheduler().execute(() -> {
            try {
                logger.info("Attempting to roll back TX:[{}]", (Object)this.transactionId);
                this.coordinator.discharge(this.transactionId, request, false);
                this.session.pumpToProtonTransport(request);
            }
            catch (Exception e) {
                request.onFailure(e);
            }
        });
        request.sync();
    }

    public AmqpTransactionCoordinator getCoordinator() {
        return this.coordinator;
    }

    AmqpTransactionId getTransactionId() {
        return this.transactionId;
    }

    boolean isInTransaction() {
        return this.transactionId != null;
    }

    void registerTxConsumer(AmqpReceiver consumer) {
        this.txReceivers.add(consumer);
    }

    private void preCommit() {
        for (AmqpReceiver receiver : this.txReceivers) {
            receiver.preCommit();
        }
    }

    private void preRollback() {
        for (AmqpReceiver receiver : this.txReceivers) {
            receiver.preRollback();
        }
    }

    private void postCommit() {
        for (AmqpReceiver receiver : this.txReceivers) {
            receiver.postCommit();
        }
        this.txReceivers.clear();
    }

    private void postRollback() {
        for (AmqpReceiver receiver : this.txReceivers) {
            receiver.postRollback();
        }
        this.txReceivers.clear();
    }
}

