/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.RowMatcher;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.ExprVisitor;
import org.infinispan.objectfilter.impl.syntax.IndexedSearchPredicateDetector;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.SyntaxTreePrinter;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParser;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.RowPropertyHelper;
import org.infinispan.query.core.impl.AggregatingQuery;
import org.infinispan.query.core.impl.EmbeddedQuery;
import org.infinispan.query.core.impl.EmptyResultQuery;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.util.logging.LogFactory;

public class QueryEngine<TypeMetadata> {
    private static final Log log = (Log)LogFactory.getLog(QueryEngine.class, Log.class);
    protected final AdvancedCache<?, ?> cache;
    protected final Matcher matcher;
    protected final Class<? extends Matcher> matcherImplClass;
    protected final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    protected final QueryCache queryCache;
    private final int defaultMaxResults;
    protected LocalQueryStatistics queryStatistics;
    protected static final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();

    protected QueryEngine(AdvancedCache<?, ?> cache, Class<? extends Matcher> matcherImplClass) {
        this.cache = cache;
        this.matcherImplClass = matcherImplClass;
        this.queryCache = (QueryCache)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cache.getCacheManager()).getComponent(QueryCache.class);
        this.queryStatistics = (LocalQueryStatistics)SecurityActions.getCacheComponentRegistry(cache).getComponent(LocalQueryStatistics.class);
        this.matcher = (Matcher)SecurityActions.getCacheComponentRegistry(cache).getComponent(matcherImplClass);
        this.defaultMaxResults = cache.getCacheConfiguration().query().defaultMaxResults();
        this.propertyHelper = ((BaseMatcher)this.matcher).getPropertyHelper();
    }

    QueryEngine(AdvancedCache<?, ?> cache) {
        this(cache, ReflectionMatcher.class);
    }

    public Query<?> buildQuery(QueryFactory queryFactory, IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, long startOffset, int maxResults, boolean local) {
        log.tracef("Building query '%s' with parameters %s", parsingResult.getQueryString(), namedParameters);
        BaseQuery<?> query = parsingResult.hasGroupingOrAggregations() ? this.buildQueryWithAggregations(queryFactory, parsingResult.getQueryString(), namedParameters, startOffset, maxResults, parsingResult, local) : this.buildQueryNoAggregations(queryFactory, parsingResult.getQueryString(), namedParameters, startOffset, maxResults, parsingResult, local);
        query.validateNamedParameters();
        return query;
    }

    protected BaseQuery<?> buildQueryWithAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, boolean local) {
        int idx;
        Class propertyType;
        if (parsingResult.getProjectedPaths() == null) {
            throw log.groupingAndAggregationQueriesMustUseProjections();
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        if (parsingResult.getGroupBy() != null) {
            for (PropertyPath p : parsingResult.getGroupBy()) {
                if (p instanceof AggregationPropertyPath) {
                    throw log.cannotHaveAggregationsInGroupByClause();
                }
                if (columns.containsKey(p)) continue;
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    throw log.multivaluedPropertyCannotBeUsedInGroupBy(p.toString());
                }
                propertyType = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                idx = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
            }
        }
        int noOfGroupingColumns = columns.size();
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
            }
            if (c != null) continue;
            propertyType = FieldAccumulator.getOutputType((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (Class)parsingResult.getProjectedTypes()[i]);
            idx = columns.size();
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (!(p instanceof AggregationPropertyPath || c != null && c.getColumnIndex() < noOfGroupingColumns)) {
                    throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(p.toString());
                }
                if (c != null) continue;
                Class propertyType2 = this.propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityMetadata(), p.asArrayPath());
                int idx2 = columns.size();
                columns.put(p, new RowPropertyHelper.ColumnMetadata(idx2, "C" + idx2, propertyType2));
            }
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = SyntaxTreePrinter.printTree((BooleanExpr)this.swapVariables(normalizedHavingClause, parsingResult.getTargetEntityMetadata(), columns, namedParameters, this.propertyHelper));
            }
        }
        for (PropertyPath p : columns.keySet()) {
            if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
            return this.buildQueryWithRepeatedAggregations(queryFactory, queryString, namedParameters, startOffset, maxResults, parsingResult, havingClause, columns, noOfGroupingColumns, local);
        }
        LinkedHashMap<String, Integer> inColumns = new LinkedHashMap<String, Integer>();
        LinkedList<FieldAccumulator> accumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            _columns[c.getColumnIndex()] = c;
            String asStringPath = p.asStringPath();
            Integer inIdx = (Integer)inColumns.get(asStringPath);
            if (inIdx == null) {
                inIdx = inColumns.size();
                inColumns.put(asStringPath, inIdx);
            }
            if (!(p instanceof AggregationPropertyPath)) continue;
            FieldAccumulator acc = FieldAccumulator.makeAccumulator((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (int)inIdx, (int)c.getColumnIndex(), (Class)c.getPropertyType());
            accumulators.add(acc);
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (String p : inColumns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append("_gen0").append('.').append(p);
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                secondPhaseQuery.append(", ");
            }
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            secondPhaseQuery.append(" ORDER BY ");
            boolean isFirst2 = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, Integer.MAX_VALUE, this.parse(firstPhaseQueryStr), local);
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, secondPhaseQueryStr, namedParameters, noOfGroupingColumns, accumulators, false, this.getObjectFilter((Matcher)new RowMatcher(_columns), secondPhaseQueryStr, namedParameters, null), startOffset, maxResults, baseQuery, this.queryStatistics, local);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final TypeMetadata targetEntityMetadata, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, final Map<String, Object> namedParameters, final ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        class PropertyReplacer
        extends ExprVisitor {
            PropertyReplacer() {
            }

            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor((Visitor)this));
                }
                return new OrExpr(visitedChildren);
            }

            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<BooleanExpr> visitedChildren = new ArrayList<BooleanExpr>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add((BooleanExpr)c.acceptVisitor((Visitor)this));
                }
                return new AndExpr(visitedChildren);
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor((Visitor)this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor((Visitor)this), (Object)likeExpr.getPattern(namedParameters));
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(propertyValueExpr.getPropertyPath());
                if (c == null) {
                    throw log.expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(propertyValueExpr.toQueryString());
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated(), propertyValueExpr.getPrimitiveType());
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(aggregationExpr.getPropertyPath());
                if (c == null) {
                    Class propertyType = propertyHelper.getPrimitivePropertyType(targetEntityMetadata, aggregationExpr.getPropertyPath().asArrayPath());
                    propertyType = FieldAccumulator.getOutputType((AggregationFunction)aggregationExpr.getAggregationType(), (Class)propertyType);
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType);
                    columns.put(aggregationExpr.getPropertyPath(), c);
                    return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), propertyType);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated(), aggregationExpr.getPrimitiveType());
            }
        }
        return (BooleanExpr)expr.acceptVisitor((Visitor)new PropertyReplacer());
    }

    private BaseQuery<?> buildQueryWithRepeatedAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, String havingClause, LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns, int noOfGroupingColumns, boolean local) {
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(SyntaxTreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        BaseQuery<?> baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, namedParameters, -1L, -1, this.parse(firstPhaseQueryStr), local);
        LinkedList<FieldAccumulator> secondPhaseAccumulators = new LinkedList<FieldAccumulator>();
        LinkedList<FieldAccumulator> thirdPhaseAccumulators = new LinkedList<FieldAccumulator>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (c.getColumnIndex() > 0) {
                secondPhaseQuery.append(", ");
            }
            if (p instanceof AggregationPropertyPath) {
                FieldAccumulator acc = FieldAccumulator.makeAccumulator((AggregationFunction)((AggregationPropertyPath)p).getAggregationFunction(), (int)c.getColumnIndex(), (int)c.getColumnIndex(), (Class)c.getPropertyType());
                if (this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) {
                    secondPhaseAccumulators.add(acc);
                    if (((AggregationPropertyPath)p).getAggregationFunction() == AggregationFunction.COUNT) {
                        c = new RowPropertyHelper.ColumnMetadata(c.getColumnIndex(), c.getColumnName(), Long.class);
                        acc = FieldAccumulator.makeAccumulator((AggregationFunction)AggregationFunction.SUM, (int)c.getColumnIndex(), (int)c.getColumnIndex(), Long.class);
                    }
                } else {
                    secondPhaseAccumulators.add(null);
                }
                thirdPhaseAccumulators.add(acc);
            } else {
                secondPhaseAccumulators.add(null);
            }
            secondPhaseQuery.append("_gen0").append('.').append(p.asStringPath());
            _columns[c.getColumnIndex()] = c;
        }
        secondPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(' ').append("_gen0");
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        HybridQuery projectingAggregatingQuery = new HybridQuery(queryFactory, this.cache, secondPhaseQueryStr, parsingResult.getStatementType(), namedParameters, this.getObjectFilter(this.matcher, secondPhaseQueryStr, namedParameters, secondPhaseAccumulators), startOffset, maxResults, (Query<?>)baseQuery, this.queryStatistics, local, false);
        StringBuilder thirdPhaseQuery = new StringBuilder();
        thirdPhaseQuery.append("SELECT ");
        for (int i = 0; i < parsingResult.getProjectedPaths().length; ++i) {
            PropertyPath p = parsingResult.getProjectedPaths()[i];
            RowPropertyHelper.ColumnMetadata c = columns.get(p);
            if (i != 0) {
                thirdPhaseQuery.append(", ");
            }
            thirdPhaseQuery.append(c.getColumnName());
        }
        thirdPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            thirdPhaseQuery.append(' ').append(havingClause);
        }
        if (parsingResult.getSortFields() != null) {
            thirdPhaseQuery.append(" ORDER BY ");
            boolean isFirst = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    thirdPhaseQuery.append(", ");
                }
                RowPropertyHelper.ColumnMetadata c = columns.get(sortField.getPath());
                thirdPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        String thirdPhaseQueryStr = thirdPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, thirdPhaseQueryStr, namedParameters, noOfGroupingColumns, thirdPhaseAccumulators, true, this.getObjectFilter((Matcher)new RowMatcher(_columns), thirdPhaseQueryStr, namedParameters, null), startOffset, maxResults, projectingAggregatingQuery, this.queryStatistics, local);
    }

    protected BaseQuery<?> buildQueryNoAggregations(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, long startOffset, int maxResults, IckleParsingResult<TypeMetadata> parsingResult, boolean local) {
        BooleanExpr normalizedWhereClause;
        if (parsingResult.hasGroupingOrAggregations()) {
            throw log.queryMustNotUseGroupingOrAggregation();
        }
        if (parsingResult.getWhereClause() != null && IndexedSearchPredicateDetector.checkIndexingRequired((BooleanExpr)parsingResult.getWhereClause())) {
            throw new IllegalStateException("The cache must be indexed in order to use full-text or spatial queries.");
        }
        if (parsingResult.getSortFields() != null) {
            for (SortField sortField : parsingResult.getSortFields()) {
                PropertyPath p = sortField.getPath();
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), p.asArrayPath())) continue;
                throw log.multivaluedPropertyCannotBeUsedInOrderBy(p.toString());
            }
        }
        if (parsingResult.getProjectedPaths() != null) {
            for (SortField sortField : parsingResult.getProjectedPaths()) {
                if (!this.propertyHelper.isRepeatedProperty(parsingResult.getTargetEntityMetadata(), sortField.asArrayPath())) continue;
                throw log.multivaluedPropertyCannotBeProjected(sortField.asStringPath());
            }
        }
        if ((normalizedWhereClause = booleanFilterNormalizer.normalize(parsingResult.getWhereClause())) == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(queryFactory, this.cache, queryString, parsingResult.getStatementType(), namedParameters, startOffset, maxResults, this.queryStatistics);
        }
        return new EmbeddedQuery(this, queryFactory, this.cache, queryString, parsingResult.getStatementType(), namedParameters, parsingResult.getProjections(), startOffset, maxResults, this.defaultMaxResults, this.queryStatistics, local);
    }

    protected IckleParsingResult<TypeMetadata> parse(String queryString) {
        return this.queryCache != null ? this.queryCache.get(this.cache.getName(), queryString, null, IckleParsingResult.class, (qs, accumulators) -> IckleParser.parse((String)qs, this.propertyHelper)) : IckleParser.parse((String)queryString, this.propertyHelper);
    }

    protected final ObjectFilter getObjectFilter(Matcher matcher, String queryString, Map<String, Object> namedParameters, List<FieldAccumulator> accumulators) {
        ObjectFilter objectFilter = this.queryCache != null ? this.queryCache.get(this.cache.getName(), queryString, accumulators, matcher.getClass(), (arg_0, arg_1) -> ((Matcher)matcher).getObjectFilter(arg_0, arg_1)) : matcher.getObjectFilter(queryString, accumulators);
        return namedParameters != null ? objectFilter.withParameters(namedParameters) : objectFilter;
    }

    protected final IckleFilterAndConverter createAndWireFilter(String queryString, Map<String, Object> namedParameters) {
        IckleFilterAndConverter filter = this.createFilter(queryString, namedParameters);
        SecurityActions.getCacheComponentRegistry(this.cache).wireDependencies((Object)filter);
        return filter;
    }

    protected IckleFilterAndConverter createFilter(String queryString, Map<String, Object> namedParameters) {
        return new IckleFilterAndConverter(queryString, namedParameters, this.matcherImplClass);
    }
}

