/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TrustManagerFactoryPlugin;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.AliasedKeyManager;
import org.apache.activemq.artemis.core.remoting.impl.ssl.PemSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.utils.ClassloadingUtil;

public class SSLSupport {
    public static final String NONE = "NONE";
    private String keystoreProvider = TransportConstants.DEFAULT_KEYSTORE_PROVIDER;
    private String keystoreType = "JKS";
    private String keystorePath = TransportConstants.DEFAULT_KEYSTORE_PATH;
    private String keystorePassword = TransportConstants.DEFAULT_KEYSTORE_PASSWORD;
    private String truststoreProvider = TransportConstants.DEFAULT_TRUSTSTORE_PROVIDER;
    private String truststoreType = "JKS";
    private String truststorePath = TransportConstants.DEFAULT_TRUSTSTORE_PATH;
    private String truststorePassword = TransportConstants.DEFAULT_TRUSTSTORE_PASSWORD;
    private String crlPath = TransportConstants.DEFAULT_CRL_PATH;
    private String sslProvider = "JDK";
    private boolean trustAll = false;
    private String trustManagerFactoryPlugin = TransportConstants.DEFAULT_TRUST_MANAGER_FACTORY_PLUGIN;
    private String keystoreAlias = TransportConstants.DEFAULT_KEYSTORE_ALIAS;

    public SSLSupport() {
    }

    public SSLSupport(SSLContextConfig config) {
        this.keystoreProvider = config.getKeystoreProvider();
        this.keystorePath = config.getKeystorePath();
        this.keystoreType = config.getKeystoreType();
        this.keystorePassword = config.getKeystorePassword();
        this.truststoreProvider = config.getTruststoreProvider();
        this.truststorePath = config.getTruststorePath();
        this.truststoreType = config.getTruststoreType();
        this.truststorePassword = config.getTruststorePassword();
        this.crlPath = config.getCrlPath();
        this.trustAll = config.isTrustAll();
        this.trustManagerFactoryPlugin = config.getTrustManagerFactoryPlugin();
        this.keystoreAlias = config.getKeystoreAlias();
    }

    public String getKeystoreProvider() {
        return this.keystoreProvider;
    }

    public SSLSupport setKeystoreProvider(String keystoreProvider) {
        this.keystoreProvider = keystoreProvider;
        return this;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public SSLSupport setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public SSLSupport setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public SSLSupport setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public String getKeystoreAlias() {
        return this.keystoreAlias;
    }

    public SSLSupport setKeystoreAlias(String keystoreAlias) {
        this.keystoreAlias = keystoreAlias;
        return this;
    }

    public String getTruststoreProvider() {
        return this.truststoreProvider;
    }

    public SSLSupport setTruststoreProvider(String truststoreProvider) {
        this.truststoreProvider = truststoreProvider;
        return this;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public SSLSupport setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
        return this;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public SSLSupport setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public SSLSupport setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public SSLSupport setCrlPath(String crlPath) {
        this.crlPath = crlPath;
        return this;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public SSLSupport setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public SSLSupport setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public String getTrustManagerFactoryPlugin() {
        return this.trustManagerFactoryPlugin;
    }

    public SSLSupport setTrustManagerFactoryPlugin(String trustManagerFactoryPlugin) {
        this.trustManagerFactoryPlugin = trustManagerFactoryPlugin;
        return this;
    }

    public SSLContext createContext() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = this.loadKeyManagers();
        TrustManager[] trustManagers = this.loadTrustManagers();
        context.init(keyManagers, trustManagers, new SecureRandom());
        return context;
    }

    public SslContext createNettyContext() throws Exception {
        SslContextBuilder sslContextBuilder;
        KeyStore keyStore = SSLSupport.loadKeystore(this.keystoreProvider, this.keystoreType, this.keystorePath, this.keystorePassword);
        if (this.keystoreAlias != null) {
            Pair<PrivateKey, X509Certificate[]> privateKeyAndCertChain = this.getPrivateKeyAndCertChain(keyStore);
            sslContextBuilder = SslContextBuilder.forServer(privateKeyAndCertChain.getA(), privateKeyAndCertChain.getB());
        } else {
            sslContextBuilder = SslContextBuilder.forServer(this.getKeyManagerFactory(keyStore, this.keystorePassword == null ? null : this.keystorePassword.toCharArray()));
        }
        return sslContextBuilder.sslProvider(SslProvider.valueOf(this.sslProvider)).trustManager(this.loadTrustManagerFactory()).build();
    }

    public SslContext createNettyClientContext() throws Exception {
        KeyStore keyStore = SSLSupport.loadKeystore(this.keystoreProvider, this.keystoreType, this.keystorePath, this.keystorePassword);
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.valueOf(this.sslProvider)).trustManager(this.loadTrustManagerFactory());
        if (this.keystoreAlias != null) {
            Pair<PrivateKey, X509Certificate[]> privateKeyAndCertChain = this.getPrivateKeyAndCertChain(keyStore);
            sslContextBuilder.keyManager(privateKeyAndCertChain.getA(), privateKeyAndCertChain.getB());
        } else {
            sslContextBuilder.keyManager(this.getKeyManagerFactory(keyStore, this.keystorePassword == null ? null : this.keystorePassword.toCharArray()));
        }
        return sslContextBuilder.build();
    }

    public static String[] parseCommaSeparatedListIntoArray(String suites) {
        String[] cipherSuites = suites.split(",");
        for (int i = 0; i < cipherSuites.length; ++i) {
            cipherSuites[i] = cipherSuites[i].trim();
        }
        return cipherSuites;
    }

    public static String parseArrayIntoCommandSeparatedList(String[] suites) {
        StringBuilder supportedSuites = new StringBuilder();
        for (String suite : suites) {
            supportedSuites.append(suite);
            supportedSuites.append(", ");
        }
        return supportedSuites.delete(supportedSuites.length() - 2, supportedSuites.length()).toString();
    }

    private TrustManagerFactory loadTrustManagerFactory() throws Exception {
        if (this.trustManagerFactoryPlugin != null) {
            return AccessController.doPrivileged(() -> ((TrustManagerFactoryPlugin)ClassloadingUtil.newInstanceFromClassLoader(SSLSupport.class, this.trustManagerFactoryPlugin, TrustManagerFactoryPlugin.class)).getTrustManagerFactory());
        }
        if (this.trustAll) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        if (!(this.truststorePath != null && !this.truststorePath.isEmpty() && !this.truststorePath.equalsIgnoreCase(NONE) || this.truststoreProvider != null && this.truststoreProvider.toUpperCase().contains("PKCS11"))) {
            return null;
        }
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore trustStore = SSLSupport.loadKeystore(this.truststoreProvider, this.truststoreType, this.truststorePath, this.truststorePassword);
        boolean ocsp = Boolean.valueOf(Security.getProperty("ocsp.enable"));
        boolean initialized = false;
        if ((ocsp || this.crlPath != null) && TrustManagerFactory.getDefaultAlgorithm().equalsIgnoreCase("PKIX")) {
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            if (this.crlPath != null) {
                pkixParams.setRevocationEnabled(true);
                Collection<? extends CRL> crlList = this.loadCRL();
                if (crlList != null) {
                    pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlList)));
                }
            }
            trustMgrFactory.init(new CertPathTrustManagerParameters(pkixParams));
            initialized = true;
        }
        if (!initialized) {
            trustMgrFactory.init(trustStore);
        }
        return trustMgrFactory;
    }

    private TrustManager[] loadTrustManagers() throws Exception {
        TrustManagerFactory trustManagerFactory = this.loadTrustManagerFactory();
        if (trustManagerFactory == null) {
            return null;
        }
        return trustManagerFactory.getTrustManagers();
    }

    private Collection<? extends CRL> loadCRL() throws Exception {
        if (this.crlPath == null) {
            return null;
        }
        URL resource = SSLSupport.validateStoreURL(this.crlPath);
        try (InputStream is = resource.openStream();){
            Collection<? extends CRL> collection = CertificateFactory.getInstance("X.509").generateCRLs(is);
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(String keystoreProvider, String keystoreType, String keystorePath, String keystorePassword) throws Exception {
        SSLSupport.checkPemProviderLoaded(keystoreType);
        KeyStore ks = keystoreProvider == null ? KeyStore.getInstance(keystoreType) : KeyStore.getInstance(keystoreType, keystoreProvider);
        InputStream in = null;
        try {
            if (keystorePath != null && !keystorePath.isEmpty() && !keystorePath.equalsIgnoreCase(NONE)) {
                URL keystoreURL = SSLSupport.validateStoreURL(keystorePath);
                in = keystoreURL.openStream();
            }
            ks.load(in, keystorePassword == null ? null : keystorePassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    public static void checkPemProviderLoaded(String keystoreType) {
        if (keystoreType != null && keystoreType.startsWith("PEM") && Security.getProvider("PEM") == null) {
            PemSupport.loadProvider();
        }
    }

    private KeyManager[] loadKeyManagers() throws Exception {
        KeyManagerFactory factory = this.loadKeyManagerFactory();
        if (factory == null) {
            return null;
        }
        KeyManager[] keyManagers = factory.getKeyManagers();
        if (this.keystoreAlias != null) {
            for (int i = 0; i < keyManagers.length; ++i) {
                KeyManager keyManager = keyManagers[i];
                if (!(keyManager instanceof X509KeyManager)) continue;
                X509KeyManager x509KeyManager = (X509KeyManager)keyManager;
                keyManagers[i] = new AliasedKeyManager(x509KeyManager, this.keystoreAlias);
            }
        }
        return keyManagers;
    }

    private KeyManagerFactory loadKeyManagerFactory() throws Exception {
        if (!(this.keystorePath != null && !this.keystorePath.isEmpty() && !this.keystorePath.equalsIgnoreCase(NONE) || this.keystoreProvider != null && this.keystoreProvider.toUpperCase().contains("PKCS11"))) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = SSLSupport.loadKeystore(this.keystoreProvider, this.keystoreType, this.keystorePath, this.keystorePassword);
        kmf.init(ks, this.keystorePassword == null ? null : this.keystorePassword.toCharArray());
        return kmf;
    }

    private static URL validateStoreURL(String storePath) throws Exception {
        assert (storePath != null);
        try {
            return new URL(storePath);
        }
        catch (MalformedURLException e) {
            File file = new File(storePath);
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            URL url = SSLSupport.findResource(storePath);
            if (url != null) {
                return url;
            }
            throw new Exception("Failed to find a store at " + storePath);
        }
    }

    private static URL findResource(String resourceName) {
        return AccessController.doPrivileged(() -> ClassloadingUtil.findResource(resourceName));
    }

    private Pair<PrivateKey, X509Certificate[]> getPrivateKeyAndCertChain(KeyStore keyStore) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        PrivateKey key = (PrivateKey)keyStore.getKey(this.keystoreAlias, this.keystorePassword.toCharArray());
        if (key == null) {
            throw ActiveMQClientMessageBundle.BUNDLE.keystoreAliasNotFound(this.keystoreAlias, this.keystorePath);
        }
        Certificate[] chain = keyStore.getCertificateChain(this.keystoreAlias);
        X509Certificate[] certChain = new X509Certificate[chain.length];
        System.arraycopy(chain, 0, certChain, 0, chain.length);
        return new Pair<PrivateKey, X509Certificate[]>(key, certChain);
    }

    private KeyManagerFactory getKeyManagerFactory(KeyStore keyStore, char[] keystorePassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePassword);
        return keyManagerFactory;
    }

    public static Pair<String, String> getValidProviderAndType(String storeProvider, String storeType) {
        if (storeProvider != null && (storeProvider.startsWith("PKCS") || storeProvider.equals("JKS") || storeProvider.equals("JCEKS"))) {
            ActiveMQClientLogger.LOGGER.oldStoreProvider(storeProvider);
            return new Pair<Object, String>(null, storeProvider);
        }
        return new Pair<String, String>(storeProvider, storeType);
    }
}

