/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class ExpirationResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = ExpirationResourceDefinition.pathElement("expiration");
    static final BinaryServiceDescriptor<ExpirationConfiguration> SERVICE_DESCRIPTOR = ExpirationResourceDefinition.serviceDescriptor(PATH, ExpirationConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();

    ExpirationResourceDefinition() {
        super(PATH);
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final long interval = Attribute.INTERVAL.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        final long lifespan = Attribute.LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong(-1L);
        final long maxIdle = Attribute.MAX_IDLE.resolveModelAttribute((ExpressionResolver)context, model).asLong(-1L);
        Supplier<ExpirationConfiguration> configurationFactory = new Supplier<ExpirationConfiguration>(){

            @Override
            public ExpirationConfiguration get() {
                return new ConfigurationBuilder().expiration().lifespan(lifespan, TimeUnit.MILLISECONDS).maxIdle(maxIdle, TimeUnit.MILLISECONDS).reaperEnabled(interval > 0L).wakeUpInterval(interval, TimeUnit.MILLISECONDS).create();
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Supplier)configurationFactory).build();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        INTERVAL("interval", new ModelNode(TimeUnit.MINUTES.toMillis(1L))),
        LIFESPAN("lifespan", null),
        MAX_IDLE("max-idle", null);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.LONG).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

