/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.CacheEntryRemover;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeSessionFactory;
import org.wildfly.clustering.session.cache.attributes.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.DefaultSessionMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionCreationMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionAccessMetaDataKey;
import org.wildfly.clustering.session.infinispan.remote.metadata.SessionCreationMetaDataKey;

@ClientListener
public class HotRodSessionFactory<MC, AV, SC>
extends CompositeSessionFactory<MC, SessionMetaDataEntry<SC>, AV, SC>
implements Registrar<Consumer<ImmutableSession>> {
    private static final Logger LOGGER = Logger.getLogger(HotRodSessionFactory.class);
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<SC>> creationMetaDataCache;
    private final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<SC>> metaDataFactory;
    private final ImmutableSessionAttributesFactory<AV> attributesFactory;
    private final CacheEntryRemover<String> attributesRemover;
    private final Collection<Consumer<ImmutableSession>> listeners = new CopyOnWriteArraySet<Consumer<ImmutableSession>>();
    private final Executor executor;

    public HotRodSessionFactory(RemoteCacheConfiguration config, SessionMetaDataFactory<SessionMetaDataEntry<SC>> metaDataFactory, SessionAttributesFactory<MC, AV> attributesFactory, Supplier<SC> localContextFactory) {
        super(metaDataFactory, attributesFactory, config.getCacheProperties(), localContextFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.attributesRemover = attributesFactory;
        this.creationMetaDataCache = config.getForceReturnCache();
        this.executor = config.getExecutor();
        this.creationMetaDataCache.addClientListener((Object)this);
    }

    public void close() {
        this.creationMetaDataCache.removeClientListener((Object)this);
        super.close();
    }

    @ClientCacheEntryExpired
    public void expired(ClientCacheEntryExpiredEvent<SessionAccessMetaDataKey> event) {
        final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<SC>> creationMetaDataCache = this.creationMetaDataCache;
        final ImmutableSessionMetaDataFactory<SessionMetaDataEntry<SC>> metaDataFactory = this.metaDataFactory;
        final ImmutableSessionAttributesFactory<AV> attributesFactory = this.attributesFactory;
        final CacheEntryRemover<String> attributesRemover = this.attributesRemover;
        final Collection<Consumer<ImmutableSession>> listeners = this.listeners;
        final String id = (String)((SessionAccessMetaDataKey)((Object)event.getKey())).getId();
        Runnable task = new Runnable(){
            final /* synthetic */ HotRodSessionFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Object attributesValue;
                SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)creationMetaDataCache.remove((Object)new SessionCreationMetaDataKey(id));
                if (creationMetaDataEntry != null && (attributesValue = attributesFactory.findValue((Object)id)) != null) {
                    DefaultSessionAccessMetaDataEntry accessMetaData = new DefaultSessionAccessMetaDataEntry();
                    Duration lastAccess = Duration.ofSeconds(1L);
                    Duration sinceCreation = Duration.between(creationMetaDataEntry.getCreationTime(), Instant.now()).minus(creationMetaDataEntry.getTimeout()).minus(lastAccess);
                    accessMetaData.setLastAccessDuration(sinceCreation, lastAccess);
                    ImmutableSessionMetaData metaData = metaDataFactory.createImmutableSessionMetaData(id, (Object)new DefaultSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaDataEntry)accessMetaData));
                    Map attributes = attributesFactory.createImmutableSessionAttributes(id, attributesValue);
                    ImmutableSession session = this.this$0.createImmutableSession(id, metaData, attributes);
                    LOGGER.tracef("Session %s has expired.", (Object)id);
                    for (Consumer listener : listeners) {
                        listener.accept(session);
                    }
                    attributesRemover.remove((Object)id);
                }
            }
        };
        this.executor.execute(task);
    }

    public Registration register(Consumer<ImmutableSession> listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

