/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.concurrent.ContextServiceTypesConfiguration;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class ContextServiceService
extends EEConcurrentAbstractService<WildFlyContextService> {
    private final String name;
    private final ContextServiceTypesConfiguration contextServiceTypesConfiguration;
    private volatile WildFlyContextService contextService;

    public ContextServiceService(String name, String jndiName, ContextServiceTypesConfiguration contextServiceTypesConfiguration) {
        super(jndiName);
        this.name = name;
        this.contextServiceTypesConfiguration = contextServiceTypesConfiguration;
    }

    @Override
    void startValue(StartContext context) {
        this.contextService = ConcurrencyImplementation.INSTANCE.newContextService(this.name, this.contextServiceTypesConfiguration);
    }

    @Override
    void stopValue(StopContext context) {
        this.contextService = null;
    }

    public WildFlyContextService getValue() throws IllegalStateException {
        WildFlyContextService value = this.contextService;
        if (value == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return value;
    }
}

