/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public abstract class AbstractRuntimeOnlyHandler
implements OperationStepHandler {
    protected AbstractRuntimeOnlyHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.requiresRuntime(context) && !this.isProfile(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (AbstractRuntimeOnlyHandler.this.resourceMustExist(context, operation)) {
                        context.readResource(PathAddress.EMPTY_ADDRESS, false);
                    }
                    AbstractRuntimeOnlyHandler.this.executeRuntimeStep(context, operation);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        if (context.getProcessType().isServer() && context.getCurrentAddress().size() > 0 && "subsystem".equals(context.getCurrentAddress().getElement(0).getKey())) {
            return true;
        }
        return context.isDefaultRequiresRuntime();
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return true;
    }

    protected abstract void executeRuntimeStep(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private boolean isProfile(OperationContext context) {
        PathAddress pa = context.getCurrentAddress();
        return pa.size() > 1 && "profile".equals(pa.getElement(0).getKey());
    }
}

