/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Objects;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.PathElement;
import org.jboss.as.version.Stability;

public interface ResourceRegistration
extends Feature {
    public PathElement getPathElement();

    public static ResourceRegistration root() {
        return ResourceRegistration.of(null);
    }

    public static ResourceRegistration of(PathElement path) {
        return path != null ? new DefaultResourceRegistration(path) : DefaultResourceRegistration.ROOT;
    }

    public static ResourceRegistration of(PathElement path, final Stability stability) {
        return path != null || stability != DefaultResourceRegistration.ROOT.getStability() ? new DefaultResourceRegistration(path){

            @Override
            public Stability getStability() {
                return stability;
            }
        } : DefaultResourceRegistration.ROOT;
    }

    public static class DefaultResourceRegistration
    implements ResourceRegistration {
        static final ResourceRegistration ROOT = new DefaultResourceRegistration(null);
        private final PathElement path;

        DefaultResourceRegistration(PathElement path) {
            this.path = path;
        }

        @Override
        public PathElement getPathElement() {
            return this.path;
        }

        public int hashCode() {
            return Objects.hashCode(this.path);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ResourceRegistration)) {
                return false;
            }
            ResourceRegistration registration = (ResourceRegistration)object;
            return Objects.equals(this.getPathElement(), registration.getPathElement()) && Objects.equals(this.getStability(), registration.getStability());
        }

        public String toString() {
            return Objects.toString(this.path);
        }
    }
}

