/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.dispatcher;

import java.util.function.Function;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.group.GroupMemberFactory;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroup;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcher;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;

public class EmbeddedCacheManagerCommandDispatcherFactory<A extends Comparable<A>, M extends GroupMember<A>>
implements CacheContainerCommandDispatcherFactory {
    private final GroupCommandDispatcherFactory<A, M> dispatcherFactory;
    private final EmbeddedCacheManagerGroup<A, M> group;
    private final Function<M, CacheContainerGroupMember> wrapper;
    private final Function<CacheContainerGroupMember, M> unwrapper;

    public EmbeddedCacheManagerCommandDispatcherFactory(EmbeddedCacheManagerCommandDispatcherFactoryConfiguration<A, M> configuration) {
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.group = new EmbeddedCacheManagerGroup<A, M>(configuration);
        this.wrapper = configuration.getAddressWrapper().compose(GroupMember::getAddress).andThen(arg_0 -> ((CacheContainerGroupMemberFactory)this.group.getGroupMemberFactory()).createGroupMember(arg_0));
        this.unwrapper = configuration.getAddressUnwrapper().compose(GroupMember::getAddress).andThen(arg_0 -> ((GroupMemberFactory)configuration.getGroup().getGroupMemberFactory()).createGroupMember(arg_0));
    }

    @Override
    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public <C> CommandDispatcher<CacheContainerGroupMember, C> createCommandDispatcher(Object id, C context, ClassLoader loader) {
        return new EmbeddedCacheManagerCommandDispatcher(this.dispatcherFactory.createCommandDispatcher(id, context, loader), this.unwrapper, this.wrapper);
    }
}

