/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.util.EnumSet;
import java.util.function.Function;
import org.jboss.marshalling.MarshallingConfiguration;

public interface MarshallingConfigurationRepository {
    public int getCurrentVersion();

    public MarshallingConfiguration getCurrentMarshallingConfiguration();

    public MarshallingConfiguration getMarshallingConfiguration(int var1) throws IOException;

    public static <C, E extends Enum<E>> MarshallingConfigurationRepository from(E current, C context) {
        return MarshallingConfigurationRepository.from(current.ordinal() + 1, (MarshallingConfiguration[])EnumSet.allOf(current.getDeclaringClass()).stream().map(c -> (MarshallingConfiguration)((Function)((Object)c)).apply(context)).toArray(MarshallingConfiguration[]::new));
    }

    public static MarshallingConfigurationRepository from(MarshallingConfiguration ... configurations) {
        return MarshallingConfigurationRepository.from(configurations.length, configurations);
    }

    public static MarshallingConfigurationRepository from(final int currentVersion, final MarshallingConfiguration ... configurations) {
        final MarshallingConfiguration currentConfiguration = configurations[currentVersion - 1];
        return new MarshallingConfigurationRepository(){

            @Override
            public int getCurrentVersion() {
                return currentVersion;
            }

            @Override
            public MarshallingConfiguration getCurrentMarshallingConfiguration() {
                return currentConfiguration;
            }

            @Override
            public MarshallingConfiguration getMarshallingConfiguration(int version) throws IOException {
                if (version <= 0 || version > configurations.length) {
                    throw new IOException(new IllegalArgumentException(Integer.toString(version)));
                }
                return configurations[version - 1];
            }
        };
    }
}

