/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.IDLID;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Parser;
import com.sun.tools.corba.se.idl.PragmaEntry;
import com.sun.tools.corba.se.idl.PragmaHandler;
import com.sun.tools.corba.se.idl.RepositoryID;
import com.sun.tools.corba.se.idl.Scanner;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.Token;
import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.BooleanAnd;
import com.sun.tools.corba.se.idl.constExpr.BooleanNot;
import com.sun.tools.corba.se.idl.constExpr.BooleanOr;
import com.sun.tools.corba.se.idl.constExpr.Equal;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.constExpr.NotEqual;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Preprocessor {
    private Vector PragmaIDs = new Vector();
    private Vector pragmaHandlers = new Vector();
    private boolean lastWasMacroID = false;
    private Parser parser;
    private Scanner scanner;
    private Hashtable symbols;
    private Vector macros;
    private Stack alreadyProcessedABranch = new Stack();
    Token token;
    private static String indent = "";

    Preprocessor() {
    }

    void init(Parser p) {
        this.parser = p;
        this.symbols = p.symbols;
        this.macros = p.macros;
    }

    protected Object clone() {
        return new Preprocessor();
    }

    Token process(Token t) throws IOException, ParseException {
        this.token = t;
        this.scanner = this.parser.scanner;
        this.scanner.escapedOK = false;
        try {
            switch (this.token.type) {
                case 307: {
                    this.include();
                    break;
                }
                case 302: {
                    this.ifClause();
                    break;
                }
                case 303: {
                    this.ifdef(false);
                    break;
                }
                case 304: {
                    this.ifdef(true);
                    break;
                }
                case 305: {
                    if (this.alreadyProcessedABranch.empty()) {
                        throw ParseException.elseNoIf(this.scanner);
                    }
                    if (((Boolean)this.alreadyProcessedABranch.peek()).booleanValue()) {
                        this.skipToEndif();
                        break;
                    }
                    this.alreadyProcessedABranch.pop();
                    this.alreadyProcessedABranch.push(new Boolean(true));
                    this.token = this.scanner.getToken();
                    break;
                }
                case 306: {
                    this.elif();
                    break;
                }
                case 308: {
                    if (this.alreadyProcessedABranch.empty()) {
                        throw ParseException.endNoIf(this.scanner);
                    }
                    this.alreadyProcessedABranch.pop();
                    this.token = this.scanner.getToken();
                    break;
                }
                case 300: {
                    this.define();
                    break;
                }
                case 301: {
                    this.undefine();
                    break;
                }
                case 311: {
                    this.pragma();
                    break;
                }
                case 313: {
                    if (!this.parser.noWarn) {
                        ParseException.warning(this.scanner, Util.getMessage("Preprocessor.unknown", this.token.name));
                    }
                }
                default: {
                    this.scanner.skipLineComment();
                    this.token = this.scanner.getToken();
                    break;
                }
            }
        }
        catch (IOException e) {
            this.scanner.escapedOK = true;
            throw e;
        }
        catch (ParseException e) {
            this.scanner.escapedOK = true;
            throw e;
        }
        this.scanner.escapedOK = true;
        return this.token;
    }

    private void include() throws IOException, ParseException {
        this.match(307);
        IncludeEntry include = this.parser.stFactory.includeEntry(this.parser.currentModule);
        include.sourceFile(this.scanner.fileEntry());
        this.scanner.fileEntry().addInclude(include);
        if (this.token.type == 204) {
            this.include2(include);
        } else if (this.token.type == 110) {
            this.include3(include);
        } else {
            int[] expected = new int[]{204, 110};
            throw ParseException.syntaxError(this.scanner, expected, this.token.type);
        }
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(include);
        } else if (this.parser.currentModule instanceof InterfaceEntry) {
            ((InterfaceEntry)this.parser.currentModule).addContained(include);
        }
    }

    private void include2(IncludeEntry include) throws IOException, ParseException {
        include.name("\"" + this.token.name + "\"");
        this.include4(include, this.token.name);
        this.match(204);
    }

    private void include3(IncludeEntry include) throws IOException, ParseException {
        if (this.token.type != 110) {
            this.match(110);
        } else {
            try {
                String includeFile = this.getUntil('>');
                this.token = this.scanner.getToken();
                include.name("<" + includeFile + ">");
                this.include4(include, includeFile);
                this.match(111);
            }
            catch (IOException e) {
                throw ParseException.syntaxError(this.scanner, ">", "EOF");
            }
        }
    }

    private void include4(IncludeEntry include, String filename) throws IOException, ParseException {
        try {
            boolean includeIsImport = this.parser.currentModule == this.parser.topLevelModule;
            include.absFilename(Util.getAbsolutePath(filename, this.parser.paths));
            this.scanner.scanIncludedFile(include, this.getFilename(filename), includeIsImport);
        }
        catch (IOException e) {
            ParseException.generic(this.scanner, e.toString());
        }
    }

    private void define() throws IOException, ParseException {
        this.match(300);
        if (this.token.equals(80)) {
            String symbol = this.scanner.getStringToEOL();
            this.symbols.put(this.token.name, symbol.trim());
            this.match(80);
        } else if (this.token.equals(81)) {
            this.symbols.put(this.token.name, "(" + this.scanner.getStringToEOL().trim());
            this.macros.addElement(this.token.name);
            this.match(81);
        } else {
            throw ParseException.syntaxError(this.scanner, 80, this.token.type);
        }
    }

    private void undefine() throws IOException, ParseException {
        this.match(301);
        if (!this.token.equals(80)) {
            throw ParseException.syntaxError(this.scanner, 80, this.token.type);
        }
        this.symbols.remove(this.token.name);
        this.macros.removeElement(this.token.name);
        this.match(80);
    }

    private void ifClause() throws IOException, ParseException {
        this.match(302);
        this.constExpr();
    }

    private void constExpr() throws IOException, ParseException {
        SymtabEntry dummyEntry = new SymtabEntry(this.parser.currentModule);
        dummyEntry.container(this.parser.currentModule);
        this.parser.parsingConditionalExpr = true;
        Expression boolExpr = this.booleanConstExpr(dummyEntry);
        this.parser.parsingConditionalExpr = false;
        boolean expr = boolExpr.value() instanceof Boolean ? (Boolean)boolExpr.value() : ((Number)boolExpr.value()).longValue() != 0L;
        this.alreadyProcessedABranch.push(new Boolean(expr));
        if (!expr) {
            this.skipToEndiforElse();
        }
    }

    Expression booleanConstExpr(SymtabEntry entry) throws IOException, ParseException {
        Expression expr = this.orExpr(null, entry);
        try {
            expr.evaluate();
        }
        catch (EvaluationException e) {
            ParseException.evaluationError(this.scanner, e.toString());
        }
        return expr;
    }

    private Expression orExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.andExpr(null, entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.andExpr(null, entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(134)) {
            this.match(this.token.type);
            BooleanOr or = this.parser.exprFactory.booleanOr(e, null);
            or.rep(e.rep() + " || ");
            return this.orExpr(or, entry);
        }
        return e;
    }

    private Expression andExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        if (e == null) {
            e = this.notExpr(entry);
        } else {
            BinaryExpr b = (BinaryExpr)e;
            b.right(this.notExpr(entry));
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(135)) {
            this.match(this.token.type);
            BooleanAnd and = this.parser.exprFactory.booleanAnd(e, null);
            and.rep(e.rep() + " && ");
            return this.andExpr(and, entry);
        }
        return e;
    }

    private Expression notExpr(SymtabEntry entry) throws IOException, ParseException {
        Expression e;
        if (this.token.equals(129)) {
            this.match(129);
            e = this.parser.exprFactory.booleanNot(this.definedExpr(entry));
            e.rep("!" + ((BooleanNot)e).operand().rep());
        } else {
            e = this.definedExpr(entry);
        }
        return e;
    }

    private Expression definedExpr(SymtabEntry entry) throws IOException, ParseException {
        if (this.token.equals(80) && this.token.name.equals("defined")) {
            this.match(80);
        }
        return this.equalityExpr(null, entry);
    }

    private Expression equalityExpr(Expression e, SymtabEntry entry) throws IOException, ParseException {
        BinaryExpr l;
        BinaryExpr g;
        if (e == null) {
            this.parser.token = this.token;
            e = this.parser.constExp(entry);
            this.token = this.parser.token;
        } else {
            BinaryExpr b = (BinaryExpr)e;
            this.parser.token = this.token;
            Expression constExpr = this.parser.constExp(entry);
            this.token = this.parser.token;
            b.right(constExpr);
            e.rep(e.rep() + b.right().rep());
        }
        if (this.token.equals(130)) {
            this.match(this.token.type);
            Equal eq = this.parser.exprFactory.equal(e, null);
            eq.rep(e.rep() + " == ");
            return this.equalityExpr(eq, entry);
        }
        if (this.token.equals(131)) {
            this.match(this.token.type);
            NotEqual n = this.parser.exprFactory.notEqual(e, null);
            n.rep(e.rep() + " != ");
            return this.equalityExpr(n, entry);
        }
        if (this.token.equals(111)) {
            this.match(this.token.type);
            g = this.parser.exprFactory.greaterThan(e, null);
            g.rep(e.rep() + " > ");
            return this.equalityExpr(g, entry);
        }
        if (this.token.equals(132)) {
            this.match(this.token.type);
            g = this.parser.exprFactory.greaterEqual(e, null);
            g.rep(e.rep() + " >= ");
            return this.equalityExpr(g, entry);
        }
        if (this.token.equals(110)) {
            this.match(this.token.type);
            l = this.parser.exprFactory.lessThan(e, null);
            l.rep(e.rep() + " < ");
            return this.equalityExpr(l, entry);
        }
        if (this.token.equals(133)) {
            this.match(this.token.type);
            l = this.parser.exprFactory.lessEqual(e, null);
            l.rep(e.rep() + " <= ");
            return this.equalityExpr(l, entry);
        }
        return e;
    }

    Expression primaryExpr(SymtabEntry entry) throws IOException, ParseException {
        Expression primary = null;
        switch (this.token.type) {
            case 80: {
                primary = this.parser.exprFactory.terminal("0", BigInteger.valueOf(0L));
                this.token = this.scanner.getToken();
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                primary = this.parser.literal(entry);
                this.token = this.parser.token;
                break;
            }
            case 108: {
                this.match(108);
                primary = this.booleanConstExpr(entry);
                this.match(109);
                primary.rep("(" + primary.rep() + ")");
                break;
            }
            default: {
                int[] expected = new int[]{205, 108};
                throw ParseException.syntaxError(this.scanner, expected, this.token.type);
            }
        }
        return primary;
    }

    private void ifDefine(boolean inParens, boolean not) throws IOException, ParseException {
        if (this.token.equals(80)) {
            if (not && this.symbols.containsKey(this.token.name) || !not && !this.symbols.containsKey(this.token.name)) {
                this.alreadyProcessedABranch.push(new Boolean(false));
                this.skipToEndiforElse();
            } else {
                this.alreadyProcessedABranch.push(new Boolean(true));
                this.match(80);
                if (inParens) {
                    this.match(109);
                }
            }
        } else {
            throw ParseException.syntaxError(this.scanner, 80, this.token.type);
        }
    }

    private void ifdef(boolean not) throws IOException, ParseException {
        if (not) {
            this.match(304);
        } else {
            this.match(303);
        }
        if (this.token.equals(80)) {
            if (not && this.symbols.containsKey(this.token.name) || !not && !this.symbols.containsKey(this.token.name)) {
                this.alreadyProcessedABranch.push(new Boolean(false));
                this.skipToEndiforElse();
            } else {
                this.alreadyProcessedABranch.push(new Boolean(true));
                this.match(80);
            }
        } else {
            throw ParseException.syntaxError(this.scanner, 80, this.token.type);
        }
    }

    private void elif() throws IOException, ParseException {
        if (this.alreadyProcessedABranch.empty()) {
            throw ParseException.elseNoIf(this.scanner);
        }
        if (((Boolean)this.alreadyProcessedABranch.peek()).booleanValue()) {
            this.skipToEndif();
        } else {
            this.match(306);
            this.constExpr();
        }
    }

    private void skipToEndiforElse() throws IOException, ParseException {
        while (!(this.token.equals(308) || this.token.equals(305) || this.token.equals(306))) {
            if (this.token.equals(303) || this.token.equals(304)) {
                this.alreadyProcessedABranch.push(new Boolean(true));
                this.skipToEndif();
                continue;
            }
            this.token = this.scanner.skipUntil('#');
        }
        this.process(this.token);
    }

    private void skipToEndif() throws IOException, ParseException {
        while (!this.token.equals(308)) {
            this.token = this.scanner.skipUntil('#');
            if (!this.token.equals(303) && !this.token.equals(304)) continue;
            this.alreadyProcessedABranch.push(new Boolean(true));
            this.skipToEndif();
        }
        this.alreadyProcessedABranch.pop();
        this.match(308);
    }

    private void pragma() throws IOException, ParseException {
        this.match(311);
        String pragmaType = this.token.name;
        this.scanner.escapedOK = true;
        this.match(80);
        PragmaEntry pragmaEntry = this.parser.stFactory.pragmaEntry(this.parser.currentModule);
        pragmaEntry.name(pragmaType);
        pragmaEntry.sourceFile(this.scanner.fileEntry());
        pragmaEntry.data(this.scanner.currentLine());
        if (this.parser.currentModule instanceof ModuleEntry) {
            ((ModuleEntry)this.parser.currentModule).addContained(pragmaEntry);
        } else if (this.parser.currentModule instanceof InterfaceEntry) {
            ((InterfaceEntry)this.parser.currentModule).addContained(pragmaEntry);
        }
        if (pragmaType.equals("ID")) {
            this.idPragma();
        } else if (pragmaType.equals("prefix")) {
            this.prefixPragma();
        } else if (pragmaType.equals("version")) {
            this.versionPragma();
        } else if (pragmaType.equals("sun_local")) {
            this.localPragma();
        } else if (pragmaType.equals("sun_localservant")) {
            this.localServantPragma();
        } else {
            this.otherPragmas(pragmaType, this.tokenToString());
            this.token = this.scanner.getToken();
        }
        this.scanner.escapedOK = false;
    }

    private void localPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        SymtabEntry anErrorOccurred = new SymtabEntry();
        SymtabEntry entry = this.parser.scopedName(this.parser.currentModule, anErrorOccurred);
        if (entry == anErrorOccurred) {
            System.out.println("Error occured ");
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
        } else {
            if (entry instanceof InterfaceEntry) {
                InterfaceEntry ent = (InterfaceEntry)entry;
                ent.setInterfaceType(4);
            }
            this.token = this.parser.token;
            String string = this.token.name;
            this.match(204);
        }
    }

    private void localServantPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        SymtabEntry anErrorOccurred = new SymtabEntry();
        SymtabEntry entry = this.parser.scopedName(this.parser.currentModule, anErrorOccurred);
        if (entry == anErrorOccurred) {
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
            System.out.println("Error occured ");
        } else {
            if (entry instanceof InterfaceEntry) {
                InterfaceEntry ent = (InterfaceEntry)entry;
                ent.setInterfaceType(3);
            }
            this.token = this.parser.token;
            String string = this.token.name;
            this.match(204);
        }
    }

    private void idPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        this.parser.isModuleLegalType(true);
        SymtabEntry anErrorOccurred = new SymtabEntry();
        SymtabEntry entry = this.parser.scopedName(this.parser.currentModule, anErrorOccurred);
        this.parser.isModuleLegalType(false);
        if (entry == anErrorOccurred) {
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
        } else {
            this.token = this.parser.token;
            String string = this.token.name;
            if (this.PragmaIDs.contains(entry)) {
                ParseException.badRepIDAlreadyAssigned(this.scanner, entry.name());
            } else if (!RepositoryID.hasValidForm(string)) {
                ParseException.badRepIDForm(this.scanner, string);
            } else {
                entry.repositoryID(new RepositoryID(string));
                this.PragmaIDs.addElement(entry);
            }
            this.match(204);
        }
    }

    private void prefixPragma() throws IOException, ParseException {
        String string = this.token.name;
        this.match(204);
        ((IDLID)Parser.repIDStack.peek()).prefix(string);
        ((IDLID)Parser.repIDStack.peek()).name("");
    }

    private void versionPragma() throws IOException, ParseException {
        this.parser.token = this.token;
        this.parser.isModuleLegalType(true);
        SymtabEntry anErrorOccurred = new SymtabEntry();
        SymtabEntry entry = this.parser.scopedName(this.parser.currentModule, anErrorOccurred);
        this.parser.isModuleLegalType(false);
        if (entry == anErrorOccurred) {
            this.scanner.skipLineComment();
            this.token = this.scanner.getToken();
        } else {
            this.token = this.parser.token;
            String string = this.token.name;
            this.match(203);
            if (entry.repositoryID() instanceof IDLID) {
                ((IDLID)entry.repositoryID()).version(string);
            }
        }
    }

    void registerPragma(PragmaHandler handler) {
        this.pragmaHandlers.addElement(handler);
    }

    private void otherPragmas(String pragmaType, String currentToken) throws IOException {
        PragmaHandler handler;
        for (int i = this.pragmaHandlers.size() - 1; i >= 0 && !(handler = (PragmaHandler)this.pragmaHandlers.elementAt(i)).process(pragmaType, currentToken); --i) {
        }
    }

    String currentToken() {
        return this.tokenToString();
    }

    SymtabEntry getEntryForName(String string) {
        boolean partialScope = false;
        boolean globalScope = false;
        if (((String)string).startsWith("::")) {
            globalScope = true;
            string = ((String)string).substring(2);
        }
        int index = ((String)string).indexOf("::");
        while (index >= 0) {
            partialScope = true;
            string = ((String)string).substring(0, index) + "/" + ((String)string).substring(index + 2);
            index = ((String)string).indexOf("::");
        }
        SymtabEntry entry = null;
        entry = globalScope ? this.parser.recursiveQualifiedEntry((String)string) : (partialScope ? this.parser.recursivePQEntry((String)string, this.parser.currentModule) : this.parser.unqualifiedEntryWMod((String)string, this.parser.currentModule));
        return entry;
    }

    String getStringToEOL() throws IOException {
        return this.scanner.getStringToEOL();
    }

    String getUntil(char c) throws IOException {
        return this.scanner.getUntil(c);
    }

    private String tokenToString() {
        if (this.token.equals(81)) {
            this.lastWasMacroID = true;
            return this.token.name;
        }
        if (this.token.equals(80)) {
            return this.token.name;
        }
        return this.token.toString();
    }

    String nextToken() throws IOException {
        if (this.lastWasMacroID) {
            this.lastWasMacroID = false;
            return "(";
        }
        this.token = this.scanner.getToken();
        return this.tokenToString();
    }

    SymtabEntry scopedName() throws IOException {
        boolean globalScope = false;
        boolean partialScope = false;
        Object name = null;
        SymtabEntry entry = null;
        try {
            if (this.token.equals(124)) {
                globalScope = true;
            } else if (this.token.equals(20)) {
                name = "Object";
                this.match(20);
            } else if (this.token.type == 45) {
                name = "ValueBase";
                this.match(45);
            } else {
                name = this.token.name;
                this.match(80);
            }
            while (this.token.equals(124)) {
                this.match(124);
                partialScope = true;
                name = name != null ? (String)name + "/" + this.token.name : this.token.name;
                this.match(80);
            }
            entry = globalScope ? this.parser.recursiveQualifiedEntry((String)name) : (partialScope ? this.parser.recursivePQEntry((String)name, this.parser.currentModule) : this.parser.unqualifiedEntryWMod((String)name, this.parser.currentModule));
        }
        catch (ParseException e) {
            entry = null;
        }
        return entry;
    }

    void skipToEOL() throws IOException {
        this.scanner.skipLineComment();
    }

    String skipUntil(char c) throws IOException {
        if (!this.lastWasMacroID || c != '(') {
            this.token = this.scanner.skipUntil(c);
        }
        return this.tokenToString();
    }

    void parseException(String message) {
        if (!this.parser.noWarn) {
            ParseException.warning(this.scanner, message);
        }
    }

    String expandMacro(String macroDef, Token t) throws IOException, ParseException {
        this.token = t;
        Vector parmValues = this.getParmValues();
        this.scanner.scanString(macroDef + "\n");
        Vector parmNames = new Vector();
        this.macro(parmNames);
        if (parmValues.size() < parmNames.size()) {
            throw ParseException.syntaxError(this.scanner, 104, 109);
        }
        if (parmValues.size() > parmNames.size()) {
            throw ParseException.syntaxError(this.scanner, 109, 104);
        }
        macroDef = this.scanner.getStringToEOL();
        for (int i = 0; i < parmNames.size(); ++i) {
            macroDef = this.replaceAll(macroDef, (String)parmNames.elementAt(i), (String)parmValues.elementAt(i));
        }
        return this.removeDoublePound(macroDef);
    }

    private void miniMatch(int type) throws ParseException {
        if (!this.token.equals(type)) {
            throw ParseException.syntaxError(this.scanner, type, this.token.type);
        }
    }

    private Vector getParmValues() throws IOException, ParseException {
        Vector<String> values = new Vector<String>();
        if (this.token.equals(80)) {
            this.match(80);
            this.miniMatch(108);
        } else if (!this.token.equals(81)) {
            throw ParseException.syntaxError(this.scanner, 80, this.token.type);
        }
        if (!this.token.equals(109)) {
            values.addElement(this.scanner.getUntil(',', ')').trim());
            this.token = this.scanner.getToken();
            this.macroParmValues(values);
        }
        return values;
    }

    private void macroParmValues(Vector values) throws IOException, ParseException {
        while (!this.token.equals(109)) {
            this.miniMatch(104);
            values.addElement(this.scanner.getUntil(',', ')').trim());
            this.token = this.scanner.getToken();
        }
    }

    private void macro(Vector parmNames) throws IOException, ParseException {
        this.match(this.token.type);
        this.match(108);
        this.macroParms(parmNames);
        this.miniMatch(109);
    }

    private void macroParms(Vector parmNames) throws IOException, ParseException {
        if (!this.token.equals(109)) {
            parmNames.addElement(this.token.name);
            this.match(80);
            this.macroParms2(parmNames);
        }
    }

    private void macroParms2(Vector parmNames) throws IOException, ParseException {
        while (!this.token.equals(109)) {
            this.match(104);
            parmNames.addElement(this.token.name);
            this.match(80);
        }
    }

    private String replaceAll(String string, String from, String to) {
        int index = 0;
        while (index != -1) {
            if ((index = ((String)string).indexOf(from, index)) == -1) continue;
            if (!this.embedded((String)string, index, index + from.length())) {
                string = index > 0 && ((String)string).charAt(index) == '#' ? ((String)string).substring(0, index) + "\"" + to + "\"" + ((String)string).substring(index + from.length()) : ((String)string).substring(0, index) + to + ((String)string).substring(index + from.length());
            }
            index += to.length();
        }
        return string;
    }

    private boolean embedded(String string, int index, int endIndex) {
        int postCh;
        boolean ret = false;
        int preCh = index == 0 ? 32 : (int)string.charAt(index - 1);
        int n = postCh = endIndex >= string.length() - 1 ? 32 : (int)string.charAt(endIndex);
        ret = preCh >= 97 && preCh <= 122 || preCh >= 65 && preCh <= 90 ? true : (postCh >= 97 && postCh <= 122 || postCh >= 65 && postCh <= 90 || postCh >= 48 && postCh <= 57 || postCh == 95 ? true : this.inQuotes(string, index));
        return ret;
    }

    private boolean inQuotes(String string, int index) {
        int quoteCount = 0;
        for (int i = 0; i < index; ++i) {
            if (string.charAt(i) != '\"') continue;
            ++quoteCount;
        }
        return quoteCount % 2 != 0;
    }

    private String removeDoublePound(String string) {
        int index = 0;
        while (index != -1) {
            if ((index = ((String)string).indexOf("##", index)) == -1) continue;
            int startSkip = index - 1;
            int stopSkip = index + 2;
            if (startSkip < 0) {
                startSkip = 0;
            }
            if (stopSkip >= ((String)string).length()) {
                stopSkip = ((String)string).length() - 1;
            }
            while (startSkip > 0 && (((String)string).charAt(startSkip) == ' ' || ((String)string).charAt(startSkip) == '\t')) {
                --startSkip;
            }
            while (stopSkip < ((String)string).length() - 1 && (((String)string).charAt(stopSkip) == ' ' || ((String)string).charAt(stopSkip) == '\t')) {
                ++stopSkip;
            }
            string = ((String)string).substring(0, startSkip + 1) + ((String)string).substring(stopSkip);
        }
        return string;
    }

    private String getFilename(String name) throws FileNotFoundException {
        Object fullName = null;
        File file = new File(name);
        if (file.canRead()) {
            fullName = name;
        } else {
            Enumeration pathList = this.parser.paths.elements();
            while (!file.canRead() && pathList.hasMoreElements()) {
                fullName = (String)pathList.nextElement() + File.separatorChar + name;
                file = new File((String)fullName);
            }
            if (!file.canRead()) {
                throw new FileNotFoundException(name);
            }
        }
        return fullName;
    }

    private void match(int type) throws IOException, ParseException {
        String string;
        if (!this.token.equals(type)) {
            throw ParseException.syntaxError(this.scanner, type, this.token.type);
        }
        this.token = this.scanner.getToken();
        if ((this.token.equals(80) || this.token.equals(81)) && (string = (String)this.symbols.get(this.token.name)) != null && !string.equals("")) {
            if (this.macros.contains(this.token.name)) {
                this.scanner.scanString(this.expandMacro(string, this.token));
                this.token = this.scanner.getToken();
            } else {
                this.scanner.scanString(string);
                this.token = this.scanner.getToken();
            }
        }
    }

    private void issueTokenWarnings() {
        if (this.parser.noWarn) {
            return;
        }
    }

    void openScope(SymtabEntry entry) {
        for (int i = this.pragmaHandlers.size() - 1; i >= 0; --i) {
            PragmaHandler handler = (PragmaHandler)this.pragmaHandlers.elementAt(i);
            handler.openScope(entry);
        }
    }

    void closeScope(SymtabEntry entry) {
        for (int i = this.pragmaHandlers.size() - 1; i >= 0; --i) {
            PragmaHandler handler = (PragmaHandler)this.pragmaHandlers.elementAt(i);
            handler.closeScope(entry);
        }
    }
}

