/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.session.ImmutableSessionMetaData;

public class SimpleImmutableSessionMetaData
implements ImmutableSessionMetaData {
    private final boolean newSession;
    private final Instant creationTime;
    private final Instant lastAccessStartTime;
    private final Instant lastAccessEndTime;
    private final Duration timeout;

    public SimpleImmutableSessionMetaData(ImmutableSessionMetaData metaData) {
        this.newSession = metaData.isNew();
        this.creationTime = metaData.getCreationTime();
        this.lastAccessStartTime = metaData.getLastAccessStartTime();
        this.lastAccessEndTime = metaData.getLastAccessEndTime();
        this.timeout = metaData.getTimeout();
    }

    public boolean isNew() {
        return this.newSession;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getLastAccessStartTime() {
        return this.lastAccessStartTime;
    }

    public Instant getLastAccessEndTime() {
        return this.lastAccessEndTime;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return String.format("{ new = %s, creation-time = %s, last-access-start-time = %s, last-access-end-time = %s, timeout = %s }", this.newSession, this.creationTime, this.lastAccessStartTime, this.lastAccessEndTime, this.timeout);
    }
}

