/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public enum JChannelFactoryServiceConfigurator implements ResourceServiceConfigurator
{
    INSTANCE;


    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        final boolean statisticsEnabled = StackResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final ServiceDependency transport = ServiceDependency.on((UnaryServiceDescriptor)TransportConfiguration.SERVICE_DESCRIPTOR, (String)name);
        Set protocolNames = resource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey());
        final ArrayList<ServiceDependency> protocols = new ArrayList<ServiceDependency>(protocolNames.size());
        for (String protocolName : protocolNames) {
            protocols.add(ServiceDependency.on((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR, (String)name, (String)protocolName));
        }
        final ServiceDependency relay = resource.hasChild(RelayResourceDefinition.PATH) ? ServiceDependency.on((UnaryServiceDescriptor)RelayConfiguration.SERVICE_DESCRIPTOR, (String)name) : ServiceDependency.of(null);
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final ServiceDependency socketBindingManager = ServiceDependency.on((NullaryServiceDescriptor)SocketBindingManager.SERVICE_DESCRIPTOR);
        ProtocolStackConfiguration configuration = new ProtocolStackConfiguration(){

            public boolean isStatisticsEnabled() {
                return statisticsEnabled;
            }

            public TransportConfiguration<? extends TP> getTransport() {
                return (TransportConfiguration)transport.get();
            }

            public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
                return protocols.stream().map(Supplier::get).collect(Collectors.toUnmodifiableList());
            }

            public String getMemberName() {
                return ((ServerEnvironment)environment.get()).getNodeName();
            }

            public Optional<RelayConfiguration> getRelay() {
                return Optional.ofNullable((RelayConfiguration)relay.get());
            }

            public SocketBindingManager getSocketBindingManager() {
                return (SocketBindingManager)socketBindingManager.get();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(StackResourceDefinition.CHANNEL_FACTORY, JChannelFactory::new, (Supplier)Functions.constantSupplier((Object)configuration)).requires(List.of(transport, relay, environment, socketBindingManager))).requires(protocols)).build();
    }
}

