/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.function.Function;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBProxyInformation;

final class EJBProxyInterceptorInformation<T> {
    private final EJBProxyInformation<T> proxyInformation;
    private final IdentityHashMap<Method, EJBClientContext.InterceptorList> interceptorsByMethod;
    private final HashMap<Method, EJBClientContext.InterceptorList> interceptorsByMethodFallback;
    private final EJBClientContext.InterceptorList classInterceptors;

    private EJBProxyInterceptorInformation(EJBProxyInformation<T> proxyInformation, IdentityHashMap<Method, EJBClientContext.InterceptorList> interceptorsByMethod, EJBClientContext.InterceptorList classInterceptors) {
        this.proxyInformation = proxyInformation;
        this.interceptorsByMethod = interceptorsByMethod;
        this.interceptorsByMethodFallback = new HashMap<Method, EJBClientContext.InterceptorList>(interceptorsByMethod);
        this.classInterceptors = classInterceptors;
    }

    static <T> EJBProxyInterceptorInformation<T> construct(Class<T> clazz, EJBClientContext clientContext) {
        EJBProxyInformation<T> proxyInformation = EJBProxyInformation.forViewType(clazz);
        Collection<EJBProxyInformation.ProxyMethodInfo> methods = proxyInformation.getMethods();
        String className = clazz.getName();
        EJBClientContext.InterceptorList list0 = EJBClientContext.defaultInterceptors;
        EJBClientContext.InterceptorList list1 = clientContext.getGlobalInterceptors();
        EJBClientContext.InterceptorList list2 = clientContext.getClassPathInterceptors();
        EJBClientContext.InterceptorList list3 = clientContext.getConfiguredPerClassInterceptors().getOrDefault(className, EJBClientContext.InterceptorList.EMPTY);
        EJBClientContext.InterceptorList list5 = proxyInformation.getClassInterceptors();
        IdentityHashMap<Method, EJBClientContext.InterceptorList> interceptorsByMethod = new IdentityHashMap<Method, EJBClientContext.InterceptorList>(methods.size());
        HashMap cache = new HashMap();
        cache.computeIfAbsent(list0, Function.identity());
        EJBClientContext.InterceptorList tailList = list3.combine(list2).combine(list1).combine(list0);
        cache.computeIfAbsent(tailList, Function.identity());
        for (EJBProxyInformation.ProxyMethodInfo method : methods) {
            EJBClientContext.InterceptorList list4 = clientContext.getConfiguredPerMethodInterceptors().getOrDefault(className, Collections.emptyMap()).getOrDefault(method.getMethodLocator(), EJBClientContext.InterceptorList.EMPTY);
            EJBClientContext.InterceptorList list6 = method.getInterceptors();
            interceptorsByMethod.put(method.getMethod(), (EJBClientContext.InterceptorList)cache.computeIfAbsent(list6.combine(list5).combine(list4).combine(tailList), Function.identity()));
        }
        return new EJBProxyInterceptorInformation<T>(proxyInformation, interceptorsByMethod, (EJBClientContext.InterceptorList)cache.computeIfAbsent(list5.combine(tailList), Function.identity()));
    }

    EJBProxyInformation<T> getProxyInformation() {
        return this.proxyInformation;
    }

    EJBClientContext.InterceptorList getInterceptors(Method method) {
        EJBClientContext.InterceptorList list = this.interceptorsByMethod.get(method);
        return list == null ? this.interceptorsByMethodFallback.get(method) : list;
    }

    EJBClientContext.InterceptorList getClassInterceptors() {
        return this.classInterceptors;
    }
}

