/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.marshalling.ByteOutput;

public final class ByteOutputs {
    private ByteOutputs() {
    }

    public static ByteOutput byteOutputOf(OutputStream delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        return new UnflushableByteOutput(new ByteOutputStream(delegate));
    }

    private static final class UnflushableByteOutput
    implements ByteOutput {
        private final ByteOutput delegate;

        public UnflushableByteOutput(ByteOutput delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void flush() throws IOException {
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }
    }

    private static final class ByteOutputStream
    implements ByteOutput {
        private final OutputStream delegate;

        ByteOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }
    }
}

