/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Map;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AbstractActiveMQComponentControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;

public class ClusterConnectionControlHandler
extends AbstractActiveMQComponentControlHandler<ClusterConnectionControl> {
    public static final ClusterConnectionControlHandler INSTANCE = new ClusterConnectionControlHandler();
    private static final String TAB = "\t";
    private static final String NEW = System.lineSeparator();

    private ClusterConnectionControlHandler() {
    }

    @Override
    protected ClusterConnectionControl getActiveMQComponentControl(ActiveMQBroker activeMQServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (ClusterConnectionControl)ClusterConnectionControl.class.cast(activeMQServer.getResource("clusterconnection." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "cluster-connection";
    }

    @Override
    protected void handleReadAttribute(String attributeName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ClusterConnectionDefinition.NODE_ID.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            if (control != null) {
                context.getResult().set(control.getNodeID());
            }
        } else if (ClusterConnectionDefinition.TOPOLOGY.getName().equals(attributeName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            if (control != null) {
                context.getResult().set(ClusterConnectionControlHandler.formatTopology(control.getTopology()));
            }
        } else {
            this.unsupportedAttribute(attributeName);
        }
    }

    public static String formatTopology(String topology) {
        Object prefix = "";
        StringBuilder builder = new StringBuilder();
        boolean params = false;
        char previous = ' ';
        for (char c : topology.toCharArray()) {
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    builder.append(c);
                    prefix = (String)prefix + TAB;
                    break;
                }
                case '?': {
                    if (' ' == previous) {
                        builder.deleteCharAt(builder.length() - 1);
                        builder.append(',').append(NEW).append((String)prefix);
                    }
                    params = true;
                    prefix = (String)prefix + TAB;
                    builder.append('{').append(NEW).append((String)prefix);
                    break;
                }
                case '&': {
                    builder.append(',').append(NEW).append((String)prefix);
                    break;
                }
                case ',': {
                    if (params) {
                        prefix = ((String)prefix).substring(0, ((String)prefix).length() - TAB.length());
                        builder.append(NEW).append((String)prefix).append('}').append(c).append(NEW).append((String)prefix);
                    } else {
                        builder.append(c);
                    }
                    params = false;
                    break;
                }
                case ']': 
                case '}': {
                    prefix = ((String)prefix).substring(0, ((String)prefix).length() - TAB.length());
                    builder.append(NEW).append((String)prefix);
                    builder.append(c);
                    break;
                }
                case ')': {
                    prefix = ((String)prefix).substring(0, ((String)prefix).length() - TAB.length());
                    builder.append(c);
                    break;
                }
                case ' ': {
                    if (44 == previous) break;
                    builder.append(c);
                    break;
                }
                default: {
                    if (',' == previous) {
                        builder.append(NEW).append((String)prefix);
                    }
                    builder.append(c);
                }
            }
            if (c == ' ' && previous == 44) continue;
            previous = c;
        }
        return builder.toString().trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-nodes".equals(operationName)) {
            ClusterConnectionControl control = (ClusterConnectionControl)this.getActiveMQComponentControl(context, operation, false);
            try {
                if (control == null) return null;
                Map nodes = control.getNodes();
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : nodes.entrySet()) {
                    result.get((String)entry.getKey()).set((String)entry.getValue());
                }
                return null;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
                return null;
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

