/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpDeliveryAnnotationsTest
extends AmqpClientTestSupport {
    private final String DELIVERY_ANNOTATION_NAME = "TEST-DELIVERY-ANNOTATION";

    @Test
    @Timeout(value=60L)
    public void testDeliveryAnnotationsStrippedFromIncoming() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setText("Test-Message");
        message.setDeliveryAnnotation("TEST-DELIVERY-ANNOTATION", this.getQueueName());
        sender.send(message);
        receiver.flow(1);
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((Long)1L, () -> ((Queue)queue).getMessageCount(), (long)5000L, (long)25L);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertNull((Object)received.getDeliveryAnnotation("TEST-DELIVERY-ANNOTATION"));
        sender.close();
        connection.close();
    }
}

