/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PagedSNFTopicDistributionTest
extends ClusterTestBase {
    public boolean isNetty() {
        return true;
    }

    @Test
    public void testTopicWhileSNFPaged() throws Exception {
        TextMessage message;
        int i;
        TopicSubscriber consumer;
        Topic topic;
        Session session;
        Topic topic2;
        Session session2;
        int nmessages = 100;
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupClusterConnection("cluster0", "topics", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "topics", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        PagedSNFTopicDistributionTest.waitForTopology(this.servers[0], 2);
        PagedSNFTopicDistributionTest.waitForTopology(this.servers[1], 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.servers[0].addAddressInfo(new AddressInfo("topics.A").addRoutingType(RoutingType.MULTICAST));
        this.servers[1].addAddressInfo(new AddressInfo("topics.A").addRoutingType(RoutingType.MULTICAST));
        ConnectionFactory factoryServer0 = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        ConnectionFactory factoryServer1 = CFUtil.createConnectionFactory("core", "tcp://localhost:61617");
        try (Connection connection = factoryServer0.createConnection();){
            connection.setClientID("server0");
            session2 = connection.createSession(false, 1);
            topic2 = session2.createTopic("topics.A");
            session2.createDurableSubscriber(topic2, "topic-server0");
        }
        connection = factoryServer1.createConnection();
        try {
            connection.setClientID("server1");
            session2 = connection.createSession(false, 1);
            topic2 = session2.createTopic("topics.A");
            session2.createDurableSubscriber(topic2, "topic-server1");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        this.waitForBindings(0, "topics.A", 1, 0, false);
        this.waitForBindings(1, "topics.A", 1, 0, false);
        this.servers[0].getPostOffice().getAllBindings().forEach(b -> {
            if (b instanceof LocalQueueBinding) {
                try {
                    ((LocalQueueBinding)b).getQueue().getPagingStore().startPaging();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        connection = factoryServer0.createConnection();
        try {
            session2 = connection.createSession(true, 1);
            topic2 = session2.createTopic("topics.A");
            MessageProducer producer = session2.createProducer((Destination)topic2);
            for (int i2 = 0; i2 < 100; ++i2) {
                producer.send((Message)session2.createTextMessage("msg " + i2));
            }
            session2.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        HashMap<Integer, AtomicInteger> counters = this.countJournal(this.servers[0].getConfiguration());
        Assertions.assertEquals((int)0, (int)this.getCounter((byte)32, counters), (String)"There are routed messages on the journal");
        Assertions.assertEquals((int)0, (int)this.getCounter((byte)31, counters), (String)"There are routed messages on the journal");
        Assertions.assertEquals((int)0, (int)this.getCounter((byte)45, counters), (String)"There are routed messages on the journal");
        try (Connection connection = factoryServer1.createConnection();){
            connection.setClientID("server1");
            session = connection.createSession(false, 1);
            topic = session.createTopic("topics.A");
            consumer = session.createDurableSubscriber(topic, "topic-server1");
            connection.start();
            for (i = 0; i < 100; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("msg " + i), (Object)message.getText());
            }
        }
        connection = factoryServer0.createConnection();
        try {
            connection.setClientID("server0");
            session = connection.createSession(false, 1);
            topic = session.createTopic("topics.A");
            consumer = session.createDurableSubscriber(topic, "topic-server0");
            connection.start();
            for (i = 0; i < 100; ++i) {
                message = (TextMessage)consumer.receive(1000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("msg " + i), (Object)message.getText());
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private int getCounter(byte typeRecord, HashMap<Integer, AtomicInteger> values) {
        AtomicInteger value = values.get(typeRecord);
        if (value == null) {
            return 0;
        }
        return value.get();
    }
}

