/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackupManagerConfigTest
extends FailoverTestBase {
    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), primaryConnector.getName()).setCallTimeout(333L));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addClusterConfiguration(this.createBasicClusterConfig(primaryConnector.getName(), new String[0]));
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    @Test
    public void testCallTimeout() {
        ActiveMQServerImpl server = (ActiveMQServerImpl)this.backupServer.getServer();
        for (BackupManager.BackupConnector backupConnector : server.getBackupManager().getBackupConnectors()) {
            Wait.assertTrue(() -> backupConnector.getBackupServerLocator() != null);
            Assertions.assertEquals((long)333L, (long)backupConnector.getBackupServerLocator().getCallTimeout());
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }
}

