/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQueueTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testCreateQueueTempQueue() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        TemporaryQueue tempQueue = session.createTemporaryQueue();
        String tempQueueName = tempQueue.getQueueName();
        Queue replyQueue = session.createQueue(tempQueueName);
        MessageProducer producer = session.createProducer((Destination)replyQueue);
        producer.send(session.createMessage());
        MessageConsumer consumer = session.createConsumer((Destination)replyQueue);
        this.conn.start();
        Assertions.assertNotNull((Object)consumer.receive(10000L));
    }

    @Test
    public void testCreateQueue() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        Queue queue = this.createQueue("TestQueue");
        String queueName = queue.getQueueName();
        logger.debug("queue name is {}", (Object)queueName);
        Queue replyQueue = session.createQueue(queueName);
        MessageProducer producer = session.createProducer((Destination)replyQueue);
        producer.send(session.createMessage());
        MessageConsumer consumer = session.createConsumer((Destination)replyQueue);
        this.conn.start();
        Assertions.assertNotNull((Object)consumer.receive(10000L));
    }

    @Test
    public void testCreateTopic() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        Topic topic = this.createTopic("TestTopic");
        String topicName = topic.getTopicName();
        Topic replyTopic = session.createTopic(topicName);
        MessageConsumer consumer = session.createConsumer((Destination)replyTopic);
        this.conn.start();
        MessageProducer producer = session.createProducer((Destination)replyTopic);
        producer.send(session.createMessage());
        Assertions.assertNotNull((Object)consumer.receive(10000L));
    }

    @Test
    public void testCreateTopicTempTopic() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        TemporaryTopic tempTopic = session.createTemporaryTopic();
        String tempTopicName = tempTopic.getTopicName();
        Topic replyTopic = session.createTopic(tempTopicName);
        MessageConsumer consumer = session.createConsumer((Destination)replyTopic);
        this.conn.start();
        MessageProducer producer = session.createProducer((Destination)replyTopic);
        producer.send(session.createMessage());
        Assertions.assertNotNull((Object)consumer.receive(10000L));
    }
}

