/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionClosedOnRemotingConnectionFailureTest
extends JMSTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionClosedOnRemotingConnectionFailure() throws Exception {
        ArrayList<TransportConfiguration> connectorConfigs = new ArrayList<TransportConfiguration>();
        connectorConfigs.add(new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.jmsServer.createConnectionFactory("cffoo", false, JMSFactoryType.CF, this.registerConnectors(this.server, connectorConfigs), null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, false, 102400, false, -1, 0x100000, -1, -1, 65536, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, 0, false, null, new String[]{"/cffoo"});
        this.cf = (ConnectionFactory)this.namingContext.lookup("/cffoo");
        Connection conn = this.cf.createConnection();
        Queue queue = this.createQueue("testQueue");
        try {
            Session session = conn.createSession(false, 1);
            MessageProducer prod = session.createProducer((Destination)queue);
            MessageConsumer cons = session.createConsumer((Destination)queue);
            conn.start();
            prod.send(session.createMessage());
            Assertions.assertNotNull((Object)cons.receive());
            RemotingConnection connection = ((ClientSessionInternal)((ActiveMQSession)session).getCoreSession()).getConnection();
            connection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
            try {
                prod.send(session.createMessage());
                Assertions.fail((String)"Should throw exception");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            try {
                cons.receive();
                Assertions.fail((String)"Should throw exception");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            session.close();
            conn.close();
        }
        finally {
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

