/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmsTopicRedeliverTest
extends BasicOpenWireTest {
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean topic = true;
    protected boolean durable;
    protected long initRedeliveryDelay;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.initRedeliveryDelay = this.connection.getRedeliveryPolicy().getInitialRedeliveryDelay();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        this.session = this.connection.createSession(false, 2);
        this.consumeSession = this.connection.createSession(false, 2);
        this.producer = this.session.createProducer(null);
        if (this.topic) {
            this.consumerDestination = this.createDestination(this.session, (byte)2);
            this.producerDestination = this.createDestination(this.session, (byte)2);
        } else {
            this.consumerDestination = this.createDestination(this.session, (byte)1);
            this.producerDestination = this.createDestination(this.session, (byte)1);
        }
        this.consumer = this.createConsumer(this.getName());
        this.connection.start();
    }

    @Test
    public void testRecover() throws Exception {
        String text = "TEST";
        TextMessage sendMessage = this.session.createTextMessage(text);
        this.producer.send(this.producerDestination, (Message)sendMessage);
        Message unackMessage = this.consumer.receive(this.initRedeliveryDelay + 1000L);
        Assertions.assertNotNull((Object)unackMessage);
        String unackId = unackMessage.getJMSMessageID();
        Assertions.assertEquals((Object)((TextMessage)unackMessage).getText(), (Object)text);
        Assertions.assertFalse((boolean)unackMessage.getJMSRedelivered());
        this.consumeSession.recover();
        Message ackMessage = this.consumer.receive(this.initRedeliveryDelay + 1000L);
        Assertions.assertNotNull((Object)ackMessage);
        ackMessage.acknowledge();
        String ackId = ackMessage.getJMSMessageID();
        Assertions.assertEquals((Object)((TextMessage)ackMessage).getText(), (Object)text);
        Assertions.assertTrue((boolean)ackMessage.getJMSRedelivered());
        Assertions.assertEquals((Object)unackId, (Object)ackId);
        this.consumeSession.recover();
        Assertions.assertNull((Object)this.consumer.receiveNoWait());
    }

    protected MessageConsumer createConsumer(String durableName) throws JMSException {
        if (this.durable) {
            return this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination, durableName);
        }
        return this.consumeSession.createConsumer(this.consumerDestination);
    }
}

