/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReconnectWithSameClientIDTest
extends BasicOpenWireTest {
    protected ActiveMQConnection sameIdConnection;
    protected boolean transacted;
    protected int authMode = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectMultipleTimesWithSameClientID() throws Exception {
        try {
            this.sameIdConnection = (ActiveMQConnection)this.factory.createConnection();
            this.useConnection((Connection)this.sameIdConnection);
            for (int i = 1; i < 11; ++i) {
                try (Connection connection2 = this.factory.createConnection();){
                    this.useConnection(connection2);
                    Assertions.fail((String)("Should have thrown InvalidClientIDException on attempt" + i));
                    continue;
                }
            }
            this.sameIdConnection.close();
            this.sameIdConnection = (ActiveMQConnection)this.factory.createConnection();
            this.useConnection((Connection)this.connection);
        }
        finally {
            if (this.sameIdConnection != null) {
                this.sameIdConnection.close();
            }
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.sameIdConnection != null) {
            this.sameIdConnection.close();
            this.sameIdConnection = null;
        }
        super.tearDown();
    }

    protected void useConnection(Connection connection) throws JMSException {
        connection.setClientID("foo");
        connection.start();
    }
}

