/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataImporter;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlImportExportRbacTest
extends ActiveMQTestBase {
    private static final Logger logger;
    public static final int CONSUMER_TIMEOUT = 5000;
    private static final String QUEUE_NAME = "A1";
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory factory;
    Set<Role> permissionsOnManagementAddress = new HashSet<Role>();

    private ClientSession basicSetUp() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        Configuration configuration = this.createDefaultInVMConfig();
        configuration.setSecurityEnabled(true);
        configuration.setManagementMessageRbac(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)true));
        HashSet<Role> permissionToProduceAnyMessage = new HashSet<Role>();
        permissionToProduceAnyMessage.add(new Role("programmers", true, true, true, false, false, false, false, false, true, false, false, false));
        this.server.getSecurityRepository().addMatch(QUEUE_NAME, permissionToProduceAnyMessage);
        this.permissionsOnManagementAddress.add(new Role("programmers", true, true, true, false, true, true, true, false, true, true, true, false));
        this.server.getSecurityRepository().addMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString() + ".*", this.permissionsOnManagementAddress);
        this.server.getSecurityRepository().addMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString(), this.permissionsOnManagementAddress);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        return this.addClientSession(this.factory.createSession("first", "secret", false, true, true, false, 100));
    }

    @Test
    public void testExportWithOutAndWithQueueControlPerms() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        StringBuilder international = new StringBuilder();
        for (char x = '\u0320'; x < '\u04b0'; x = (char)(x + '\u0001')) {
            international.append(x);
        }
        String special = "\"<>'&";
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeString("Bob the giant pig " + i);
            producer.send((Message)msg);
        }
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession("first", "secret", false, true, true, false, 100);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        Queue queue = this.server.locateQueue(QUEUE_NAME);
        Assertions.assertEquals((long)0L, (long)queue.getMessageCount());
        this.server.getSecurityRepository().addMatch(SimpleString.of((String)this.server.getConfiguration().getManagementRbacPrefix()).concat(".queue.A1.getID").toString(), this.permissionsOnManagementAddress);
        xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            byte[] body = new byte[msg.getBodySize()];
            msg.getBodyBuffer().readBytes(body);
            Assertions.assertTrue((boolean)new String(body).contains("Bob the giant pig " + i));
        }
    }

    static {
        URL resource;
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

