/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.PrivateIndexingConfiguration;

public class IndexerConfig {
    private final int maxConcurrency;
    private final int rebatchRequestsSize;

    public IndexerConfig(AdvancedCache<?, ?> cache) {
        Configuration config = cache.getCacheConfiguration();
        IndexWriterConfiguration writer = config.indexing().writer();
        Integer queueSize = writer.getQueueSize();
        Integer queueCount = writer.getQueueCount();
        this.maxConcurrency = queueCount == 1 ? queueSize : (int)((double)(queueCount * queueSize) * 0.67);
        PrivateIndexingConfiguration privateConfig = (PrivateIndexingConfiguration)config.module(PrivateIndexingConfiguration.class);
        this.rebatchRequestsSize = privateConfig != null ? privateConfig.rebatchRequestsSize() : 10000;
    }

    public IndexerConfig(int maxConcurrency, int rebatchRequestsSize) {
        this.maxConcurrency = maxConcurrency;
        this.rebatchRequestsSize = rebatchRequestsSize;
    }

    public int maxConcurrency() {
        return this.maxConcurrency;
    }

    public int rebatchRequestsSize() {
        return this.rebatchRequestsSize;
    }
}

