/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.utils;

import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jts.utils.Helper;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

public class Utility {
    public static String getHierarchy(PropagationContext ctx) {
        int depth = ctx.parents != null ? ctx.parents.length : 0;
        Object hier = "PropagationContext:";
        for (int i = depth - 1; i >= 0; --i) {
            if (ctx.parents[i] == null) continue;
            hier = (String)hier + "\n" + String.valueOf(Utility.otidToUid(ctx.parents[i].otid));
        }
        hier = (String)hier + "\n" + String.valueOf(Utility.otidToUid(ctx.current.otid));
        return hier;
    }

    public static String stringVote(Vote v) {
        switch (v.value()) {
            case 0: {
                return "CosTransactions::VoteCommit";
            }
            case 1: {
                return "CosTransactions::VoteRollback";
            }
            case 2: {
                return "CosTransactions::VoteReadOnly";
            }
        }
        return "Unknown";
    }

    public static PrintWriter printStatus(PrintWriter strm, Status res) {
        strm.print(Utility.stringStatus(res));
        return strm;
    }

    public static String exceptionCode(int code) {
        switch (code) {
            case 60004: {
                return "ExceptionCodes.ADD_FAILED";
            }
            case 60003: {
                return "ExceptionCodes.ALREADY_BEGUN";
            }
            case 50002: {
                return "ExceptionCodes.ALREADY_ROLLEDBACK";
            }
            case 60001: {
                return "ExceptionCodes.ALREADY_TERMINATED";
            }
            case 40003: {
                return "ExceptionCodes.ATOMICACTION_COMMIT";
            }
            case 40004: {
                return "ExceptionCodes.ATOMICACTION_ROLLBACK";
            }
            case 45002: {
                return "ExceptionCodes.BAD_TRANSACTION_CONTEXT";
            }
            case 50001: {
                return "ExceptionCodes.FAILED_TO_COMMIT";
            }
            case 30002: {
                return "ExceptionCodes.GETTIMEOUT_FAILED";
            }
            case 40006: {
                return "ExceptionCodes.HEURISTIC_COMMIT";
            }
            case 20001: {
                return "ExceptionCodes.INACTIVE_TRANSACTION";
            }
            case 60007: {
                return "ExceptionCodes.INVALID_ACTION";
            }
            case 45001: {
                return "ExceptionCodes.INVALID_TIMEOUT";
            }
            case 60000: {
                return "ExceptionCodes.INVALID_TRANSACTION_BASE";
            }
            case 50003: {
                return "ExceptionCodes.MARKED_ROLLEDBACK";
            }
            case 40005: {
                return "ExceptionCodes.NO_TRANSACTION";
            }
            case 80001: {
                return "ExceptionCodes.NO_TXCONTEXT";
            }
            case 70001: {
                return "ExceptionCodes.NOT_CURRENT_TRANSACTION";
            }
            case 40000: {
                return "ExceptionCodes.OTS_BAD_OPERATION_BASE";
            }
            case 45000: {
                return "ExceptionCodes.OTS_BAD_PARAM_BASE";
            }
            case 20000: {
                return "ExceptionCodes.OTS_GENERAL_BASE";
            }
            case 30000: {
                return "ExceptionCodes.OTS_UNKNOWN_BASE";
            }
            case 40001: {
                return "ExceptionCodes.SERVERAA_COMMIT";
            }
            case 70002: {
                return "ExceptionCodes.SERVERAA_NO_CONTROL";
            }
            case 40002: {
                return "ExceptionCodes.SERVERAA_PREPARE";
            }
            case 30004: {
                return "ExceptionCodes.SYNCHRONIZATION_EXCEPTION";
            }
            case 80000: {
                return "ExceptionCodes.TRANSACTION_REQUIRED_BASE";
            }
            case 50000: {
                return "ExceptionCodes.TRANSACTION_ROLLEDBACK_BASE";
            }
            case 60005: {
                return "ExceptionCodes.UNAVAILABLE_COORDINATOR";
            }
            case 60006: {
                return "ExceptionCodes.UNAVAILABLE_TRANSACTION";
            }
            case 30003: {
                return "ExceptionCodes.UNEXPECTED_SYSTEMEXCEPTION";
            }
            case 30001: {
                return "ExceptionCodes.UNKNOWN_EXCEPTION";
            }
            case 60002: {
                return "ExceptionCodes.UNKNOWN_INVALID";
            }
            case 70000: {
                return "ExceptionCodes.WRONG_TRANSACTION_BASE";
            }
        }
        return "Unknown";
    }

    public static String stringStatus(Status res) {
        switch (res.value()) {
            case 0: {
                return "CosTransactions::StatusActive";
            }
            case 1: {
                return "CosTransactions::StatusMarkedRollback";
            }
            case 2: {
                return "CosTransactions::StatusPrepared";
            }
            case 3: {
                return "CosTransactions::StatusCommitted";
            }
            case 4: {
                return "CosTransactions::StatusRolledBack";
            }
            case 5: {
                return "CosTransactions::StatusUnknown";
            }
            case 6: {
                return "CosTransactions::StatusPreparing";
            }
            case 7: {
                return "CosTransactions::StatusCommitting";
            }
            case 8: {
                return "CosTransactions::StatusRollingBack";
            }
            case 9: {
                return "CosTransactions::StatusNoTransaction";
            }
        }
        return "Unknown";
    }

    public static final Uid getUid(Control cont) {
        try {
            UidCoordinator coord = Helper.getUidCoordinator(cont);
            if (coord == null) {
                throw new BAD_PARAM();
            }
            return Helper.getUid(coord);
        }
        catch (BAD_PARAM ex) {
            return Uid.nullUid();
        }
    }

    public static final otid_t uidToOtid(Uid theUid) {
        return theUid != null ? Utility.uidToOtid(theUid.stringForm()) : null;
    }

    public static final otid_t uidToOtid(String theUid) {
        if (theUid == null) {
            return null;
        }
        otid_t otid = new otid_t();
        byte[] b = theUid.getBytes(StandardCharsets.UTF_8);
        if (TxControl.getXANodeName() == null) {
            throw new IllegalStateException(jtsLogger.i18NLogger.get_nodename_null());
        }
        byte[] nodeName = TxControl.getXANodeName().getBytes(StandardCharsets.UTF_8);
        otid.formatID = 0;
        otid.tid = new byte[b.length + nodeName.length];
        otid.bqual_length = nodeName.length;
        System.arraycopy(b, 0, otid.tid, 0, b.length);
        System.arraycopy(nodeName, 0, otid.tid, b.length, nodeName.length);
        b = null;
        return otid;
    }

    public static final Uid otidToUid(otid_t otid) {
        if (otid.bqual_length > 0) {
            int uidLength = otid.tid.length - otid.bqual_length;
            byte[] theUid = new byte[uidLength];
            System.arraycopy(otid.tid, 0, theUid, 0, uidLength);
            Uid u = new Uid(new String(theUid, StandardCharsets.UTF_8), true);
            theUid = null;
            return u;
        }
        return Uid.nullUid();
    }
}

