/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.infinispan.client.hotrod.impl.operations.NoCachePingOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.impl.transport.netty.OperationChannel;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@ChannelHandler.Sharable
class ActivationHandler
extends ChannelInboundHandlerAdapter {
    static final String NAME = "activation-handler";
    private static final Log log = LogFactory.getLog(ActivationHandler.class);
    static final ActivationHandler INSTANCE = new ActivationHandler();
    static final Object ACTIVATION_EVENT = new Object();

    ActivationHandler() {
    }

    protected void activate(ChannelHandlerContext ctx, OperationChannel operationChannel) {
        Channel channel = ctx.channel();
        if (log.isTraceEnabled()) {
            log.tracef("Activating channel %s", channel);
        }
        NoCachePingOperation ping = new NoCachePingOperation();
        operationChannel.forceSendOperation(ping);
        ping.whenComplete((r, t) -> {
            ctx.pipeline().remove((ChannelHandler)this);
            if (t != null) {
                channel.pipeline().fireExceptionCaught(t);
            } else {
                operationChannel.markAcceptingRequests();
            }
        });
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        OperationChannel operationChannel = (OperationChannel)ctx.channel().attr(OperationChannel.OPERATION_CHANNEL_ATTRIBUTE_KEY).get();
        if (operationChannel != null) {
            this.activate(ctx, operationChannel);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt == ACTIVATION_EVENT) {
            if (((HeaderDecoder)ctx.pipeline().get("header-decoder")).getChannel() != null) {
                this.activate(ctx, (OperationChannel)ctx.channel().attr(OperationChannel.OPERATION_CHANNEL_ATTRIBUTE_KEY).get());
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

