/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

public class IdleStateHandlerNoUnvoid
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final boolean observeOutput;
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private Future<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private Future<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private Future<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private static final byte ST_INITIALIZED = 1;
    private static final byte ST_DESTROYED = 2;
    private boolean reading;
    private long lastChangeCheckTimeStamp;
    private int lastMessageHashCode;
    private long lastPendingWriteBytes;
    private long lastFlushProgress;

    public IdleStateHandlerNoUnvoid(int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this(readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandlerNoUnvoid(long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        this(false, readerIdleTime, writerIdleTime, allIdleTime, unit);
    }

    public IdleStateHandlerNoUnvoid(boolean observeOutput, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        ObjectUtil.checkNotNull((Object)((Object)unit), (String)"unit");
        this.observeOutput = observeOutput;
        this.readerIdleTimeNanos = readerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(readerIdleTime), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = writerIdleTime <= 0L ? 0L : Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
        this.allIdleTimeNanos = allIdleTime <= 0L ? 0L : Math.max(unit.toNanos(allIdleTime), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            this.firstAllIdleEvent = true;
            this.firstReaderIdleEvent = true;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
        ctx.fireChannelReadComplete();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastWriteTime = this.ticksInNanos();
            this.firstAllIdleEvent = true;
            this.firstWriterIdleEvent = true;
        }
        ctx.write(msg, promise);
    }

    public void resetReadTimeout() {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastReadTime = this.ticksInNanos();
            this.reading = false;
        }
    }

    public void resetWriteTimeout() {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.lastWriteTime = this.ticksInNanos();
        }
    }

    private void initialize(ChannelHandlerContext ctx) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        this.initOutputChanged(ctx);
        this.lastReadTime = this.lastWriteTime = this.ticksInNanos();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = this.schedule(ctx, new ReaderIdleTimeoutTask(ctx), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = this.schedule(ctx, new WriterIdleTimeoutTask(ctx), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = this.schedule(ctx, new AllIdleTimeoutTask(ctx), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    long ticksInNanos() {
        return System.nanoTime();
    }

    Future<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay, TimeUnit unit) {
        return ctx.executor().schedule(task, delay, unit);
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        ctx.fireUserEventTriggered((Object)evt);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState state, boolean first) {
        switch (state) {
            case ALL_IDLE: {
                return first ? IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT : IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                return first ? IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT : IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                return first ? IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT : IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new IllegalArgumentException("Unhandled: state=" + String.valueOf(state) + ", first=" + first);
    }

    private void initOutputChanged(ChannelHandlerContext ctx) {
        Channel channel;
        Channel.Unsafe unsafe;
        ChannelOutboundBuffer buf;
        if (this.observeOutput && (buf = (unsafe = (channel = ctx.channel()).unsafe()).outboundBuffer()) != null) {
            this.lastMessageHashCode = System.identityHashCode(buf.current());
            this.lastPendingWriteBytes = buf.totalPendingWriteBytes();
            this.lastFlushProgress = buf.currentProgress();
        }
    }

    private boolean hasOutputChanged(ChannelHandlerContext ctx, boolean first) {
        if (this.observeOutput) {
            Channel channel;
            Channel.Unsafe unsafe;
            ChannelOutboundBuffer buf;
            if (this.lastChangeCheckTimeStamp != this.lastWriteTime) {
                this.lastChangeCheckTimeStamp = this.lastWriteTime;
                if (!first) {
                    return true;
                }
            }
            if ((buf = (unsafe = (channel = ctx.channel()).unsafe()).outboundBuffer()) != null) {
                long flushProgress;
                int messageHashCode = System.identityHashCode(buf.current());
                long pendingWriteBytes = buf.totalPendingWriteBytes();
                if (messageHashCode != this.lastMessageHashCode || pendingWriteBytes != this.lastPendingWriteBytes) {
                    this.lastMessageHashCode = messageHashCode;
                    this.lastPendingWriteBytes = pendingWriteBytes;
                    if (!first) {
                        return true;
                    }
                }
                if ((flushProgress = buf.currentProgress()) != this.lastFlushProgress) {
                    this.lastFlushProgress = flushProgress;
                    return !first;
                }
            }
        }
        return false;
    }

    private final class ReaderIdleTimeoutTask
    extends AbstractIdleTask {
        ReaderIdleTimeoutTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            long nextDelay = IdleStateHandlerNoUnvoid.this.readerIdleTimeNanos;
            if (!IdleStateHandlerNoUnvoid.this.reading) {
                nextDelay -= IdleStateHandlerNoUnvoid.this.ticksInNanos() - IdleStateHandlerNoUnvoid.this.lastReadTime;
            }
            if (nextDelay <= 0L) {
                IdleStateHandlerNoUnvoid.this.readerIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, IdleStateHandlerNoUnvoid.this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first = IdleStateHandlerNoUnvoid.this.firstReaderIdleEvent;
                IdleStateHandlerNoUnvoid.this.firstReaderIdleEvent = false;
                try {
                    IdleStateEvent event = IdleStateHandlerNoUnvoid.this.newIdleStateEvent(IdleState.READER_IDLE, first);
                    IdleStateHandlerNoUnvoid.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    ctx.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandlerNoUnvoid.this.readerIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class WriterIdleTimeoutTask
    extends AbstractIdleTask {
        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            long lastWriteTime = IdleStateHandlerNoUnvoid.this.lastWriteTime;
            long nextDelay = IdleStateHandlerNoUnvoid.this.writerIdleTimeNanos - (IdleStateHandlerNoUnvoid.this.ticksInNanos() - lastWriteTime);
            if (nextDelay <= 0L) {
                IdleStateHandlerNoUnvoid.this.writerIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, IdleStateHandlerNoUnvoid.this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first = IdleStateHandlerNoUnvoid.this.firstWriterIdleEvent;
                IdleStateHandlerNoUnvoid.this.firstWriterIdleEvent = false;
                try {
                    if (IdleStateHandlerNoUnvoid.this.hasOutputChanged(ctx, first)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandlerNoUnvoid.this.newIdleStateEvent(IdleState.WRITER_IDLE, first);
                    IdleStateHandlerNoUnvoid.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    ctx.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandlerNoUnvoid.this.writerIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class AllIdleTimeoutTask
    extends AbstractIdleTask {
        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            super(ctx);
        }

        @Override
        protected void run(ChannelHandlerContext ctx) {
            long nextDelay = IdleStateHandlerNoUnvoid.this.allIdleTimeNanos;
            if (!IdleStateHandlerNoUnvoid.this.reading) {
                nextDelay -= IdleStateHandlerNoUnvoid.this.ticksInNanos() - Math.max(IdleStateHandlerNoUnvoid.this.lastReadTime, IdleStateHandlerNoUnvoid.this.lastWriteTime);
            }
            if (nextDelay <= 0L) {
                IdleStateHandlerNoUnvoid.this.allIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, IdleStateHandlerNoUnvoid.this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
                boolean first = IdleStateHandlerNoUnvoid.this.firstAllIdleEvent;
                IdleStateHandlerNoUnvoid.this.firstAllIdleEvent = false;
                try {
                    if (IdleStateHandlerNoUnvoid.this.hasOutputChanged(ctx, first)) {
                        return;
                    }
                    IdleStateEvent event = IdleStateHandlerNoUnvoid.this.newIdleStateEvent(IdleState.ALL_IDLE, first);
                    IdleStateHandlerNoUnvoid.this.channelIdle(ctx, event);
                }
                catch (Throwable t) {
                    ctx.fireExceptionCaught(t);
                }
            } else {
                IdleStateHandlerNoUnvoid.this.allIdleTimeout = IdleStateHandlerNoUnvoid.this.schedule(ctx, this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static abstract class AbstractIdleTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        AbstractIdleTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            this.run(this.ctx);
        }

        protected abstract void run(ChannelHandlerContext var1);
    }
}

