/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem.parsing;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ExtensionXml;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class AppClientXml_All
extends CommonXml {
    private final IntVersion version;
    private final String namespaceUri;
    private final ExtensionXml extensionXml;

    AppClientXml_All(ModuleLoader loader, ExtensionRegistry extensionRegistry, IntVersion version, String namespaceUri) {
        super((SocketBindingsXml)new AppClientSocketBindingsXml());
        this.extensionXml = new ExtensionXml(loader, null, extensionRegistry);
        this.version = version;
        this.namespaceUri = namespaceUri;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> value) throws XMLStreamException {
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.SERVER) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        IntVersion version1_1 = new IntVersion(new int[]{1, 1});
        IntVersion version18 = new IntVersion(new int[]{18});
        if (this.version.compareTo(version1_1) < 0) {
            this.readServerElement_1_0(reader, address, value);
        } else if (this.version.compareTo(version18) < 0) {
            this.readServerElement_1_1(reader, address, value);
        } else {
            this.readServerElement_18(reader, address, value);
        }
    }

    private void readServerElement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (ParseUtils.isXmlNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                    case SCHEMA_LOCATION: {
                        this.parseSchemaLocations(reader, address, list, i);
                        continue block7;
                    }
                    case NO_NAMESPACE_SCHEMA_LOCATION: {
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                case NAME: {
                    serverName = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespaceUri, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.version, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerElement_1_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (ParseUtils.isXmlNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                    case SCHEMA_LOCATION: {
                        this.parseSchemaLocations(reader, address, list, i);
                        continue block7;
                    }
                    case NO_NAMESPACE_SCHEMA_LOCATION: {
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                case NAME: {
                    serverName = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespaceUri, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, this.namespaceUri, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.version, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerElement_18(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        String serverName = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            if (ParseUtils.isXmlNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                    case SCHEMA_LOCATION: {
                        this.parseSchemaLocations(reader, address, list, i);
                        continue block7;
                    }
                    case NO_NAMESPACE_SCHEMA_LOCATION: {
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                case NAME: {
                    serverName = reader.getAttributeValue(i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        if (element == Element.EXTENSIONS) {
            this.extensionXml.parseExtensions(reader, address, this.namespaceUri, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, this.version, this.namespaceUri, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSocketBindingGroup(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    continue block9;
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block10: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)this.namespaceUri);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> configuredSubsystemTypes = new HashSet<String>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (!configuredSubsystemTypes.add(reader.getNamespaceURI())) {
                throw AppClientLogger.ROOT_LOGGER.duplicateSubsystemDeclaration(reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            reader.handleAny(subsystems);
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void setServerName(ModelNode address, List<ModelNode> operationList, String value) {
        if (value != null && value.length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (String)value);
            operationList.add(update);
        }
    }

    static class AppClientSocketBindingsXml
    extends SocketBindingsXml {
        AppClientSocketBindingsXml() {
        }

        protected void writeExtraAttributes(XMLExtendedStreamWriter writer, ModelNode bindingGroup) throws XMLStreamException {
            SocketBindingGroupResourceDefinition.PORT_OFFSET.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        }
    }
}

