/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceRegistry;

public class GetDataSourceClassInfoOperationHandler
implements OperationStepHandler {
    public static final GetDataSourceClassInfoOperationHandler INSTANCE = new GetDataSourceClassInfoOperationHandler();

    private GetDataSourceClassInfoOperationHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String driverName = context.getCurrentAddressValue();
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceRegistry registry = context.getServiceRegistry(false);
                    DriverRegistry driverRegistry = (DriverRegistry)registry.getRequiredService(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE).getValue();
                    ServiceModuleLoader serviceModuleLoader = (ServiceModuleLoader)registry.getRequiredService(Services.JBOSS_SERVICE_MODULE_LOADER).getValue();
                    InstalledDriver driver = driverRegistry.getInstalledDriver(driverName);
                    if (driver == null) {
                        context.getResult().set(new ModelNode());
                        return;
                    }
                    ModelNode result = GetDataSourceClassInfoOperationHandler.dsClsInfoNode(serviceModuleLoader, driver.getModuleName(), driver.getDataSourceClassName(), driver.getXaDataSourceClassName());
                    context.getResult().set(result);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    static ModelNode dsClsInfoNode(ServiceModuleLoader serviceModuleLoader, String mid, String dsClsName, String xaDSClsName) throws OperationFailedException {
        ModelNode result = new ModelNode();
        if (dsClsName != null) {
            ModelNode dsNode = new ModelNode();
            dsNode.get(dsClsName).set(GetDataSourceClassInfoOperationHandler.findPropsFromCls(serviceModuleLoader, mid, dsClsName));
            result.add(dsNode);
        }
        if (xaDSClsName != null) {
            ModelNode xaDSNode = new ModelNode();
            xaDSNode.get(xaDSClsName).set(GetDataSourceClassInfoOperationHandler.findPropsFromCls(serviceModuleLoader, mid, xaDSClsName));
            result.add(xaDSNode);
        }
        return result;
    }

    private static ModelNode findPropsFromCls(ServiceModuleLoader serviceModuleLoader, String mid, String clsName) throws OperationFailedException {
        Class<?> cls = null;
        if (mid != null) {
            try {
                cls = Class.forName(clsName, true, (ClassLoader)serviceModuleLoader.loadModule(mid.toString()).getClassLoader());
            }
            catch (ClassNotFoundException | ModuleLoadException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.failedToLoadDataSourceClass(clsName, e);
            }
        }
        if (cls == null) {
            try {
                cls = Class.forName(clsName);
            }
            catch (ClassNotFoundException e) {
                throw ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.failedToLoadDataSourceClass(clsName, e);
            }
        }
        TreeMap methodsMap = new TreeMap();
        for (Method method : GetDataSourceClassInfoOperationHandler.possiblePropsSetters(cls)) {
            methodsMap.putIfAbsent(GetDataSourceClassInfoOperationHandler.deCapitalize(method.getName().substring(3)), method.getParameterTypes()[0]);
        }
        ModelNode result = new ModelNode();
        for (Map.Entry prop : methodsMap.entrySet()) {
            result.get((String)prop.getKey()).set(((Type)prop.getValue()).getTypeName());
        }
        return result;
    }

    private static boolean isTypeMatched(Class<?> clz) {
        if (clz.equals(String.class)) {
            return true;
        }
        if (clz.equals(Byte.TYPE) || clz.equals(Byte.class)) {
            return true;
        }
        if (clz.equals(Short.TYPE) || clz.equals(Short.class)) {
            return true;
        }
        if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
            return true;
        }
        if (clz.equals(Long.TYPE) || clz.equals(Long.class)) {
            return true;
        }
        if (clz.equals(Float.TYPE) || clz.equals(Float.class)) {
            return true;
        }
        if (clz.equals(Double.TYPE) || clz.equals(Double.class)) {
            return true;
        }
        if (clz.equals(Boolean.TYPE) || clz.equals(Boolean.class)) {
            return true;
        }
        if (clz.equals(Character.TYPE) || clz.equals(Character.class)) {
            return true;
        }
        if (clz.equals(InetAddress.class)) {
            return true;
        }
        if (clz.equals(Class.class)) {
            return true;
        }
        return clz.equals(Properties.class);
    }

    private static String deCapitalize(String str) {
        if (str.length() == 1) {
            return str.toLowerCase(Locale.US);
        }
        if (str.equals(str.toUpperCase(Locale.US))) {
            return str;
        }
        return str.substring(0, 1).toLowerCase(Locale.US) + str.substring(1);
    }

    private static List<Method> possiblePropsSetters(Class<?> clz) {
        ArrayList<Method> hits = new ArrayList<Method>();
        while (!clz.equals(Object.class)) {
            Method[] methods = clz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (Modifier.isStatic(method.getModifiers()) || method.getName().length() <= 3 || !method.getName().startsWith("set") || method.getParameterCount() != 1 || !GetDataSourceClassInfoOperationHandler.isTypeMatched(method.getParameterTypes()[0])) continue;
                hits.add(method);
            }
            clz = clz.getSuperclass();
        }
        return hits;
    }
}

