/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.iiop.openjdk.deployment.IIOPDeploymentMarker;

public class EjbDependencyDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private static final String EJB_SUBSYSTEM = "org.jboss.as.ejb3";
    private static final String EJB_CLIENT = "org.jboss.ejb-client";
    private static final String EJB_NAMING_CLIENT = "org.wildfly.naming-client";
    private static final String EJB_IIOP_CLIENT = "org.jboss.iiop-client";
    private static final String IIOP_OPENJDK = "org.wildfly.iiop-openjdk";
    private static final String EJB_API = "jakarta.ejb.api";
    private static final String HTTP_EJB = "org.wildfly.http-client.ejb";
    private static final String HTTP_TRANSACTION = "org.wildfly.http-client.transaction";
    private static final String HTTP_NAMING = "org.wildfly.http-client.naming";
    private static final String CLUSTERING_EJB_CLIENT = "org.wildfly.clustering.ejb.client";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)EJB_API).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)EJB_CLIENT).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)EJB_NAMING_CLIENT).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)EJB_IIOP_CLIENT).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)EJB_SUBSYSTEM).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)HTTP_EJB).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)HTTP_NAMING).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)HTTP_TRANSACTION).setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)CLUSTERING_EJB_CLIENT).setImportServices(true).build());
        if (IIOPDeploymentMarker.isIIOPDeployment((DeploymentUnit)deploymentUnit)) {
            moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)IIOP_OPENJDK).build());
        }
        if (!EjbDeploymentMarker.isEjbDeployment((DeploymentUnit)deploymentUnit) && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.APPLICATION_CLIENT, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (Boolean.getBoolean("org.jboss.as.ejb3.EMBEDDED")) {
            moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"Classpath").build());
        }
    }
}

