/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntKeyMap<V>
implements Cloneable,
Serializable,
Iterable<Entry<V>> {
    private static final int DEFAULT_CAPACITY = 8;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.67f;
    private transient Entry<V>[] table;
    private transient int size;
    private transient int threshold;
    private final float loadFactor;
    private static final long serialVersionUID = -6864280848239317243L;

    public IntKeyMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Can not have a negative size table!");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (!(loadFactor > 0.0f) || !(loadFactor <= 1.0f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than or equal to 1");
        }
        this.loadFactor = loadFactor;
        this.init(initialCapacity, loadFactor);
    }

    public IntKeyMap(IntKeyMap<? extends V> map) {
        this.table = (Entry[])map.table.clone();
        this.loadFactor = map.loadFactor;
        this.size = map.size;
        this.threshold = map.threshold;
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.threshold = (int)((float)c * loadFactor);
        if (initialCapacity > this.threshold && c < 0x40000000) {
            this.threshold = (int)((float)(c <<= 1) * loadFactor);
        }
        this.table = new Entry[c];
    }

    public IntKeyMap(int initialCapacity) {
        this(initialCapacity, 0.67f);
    }

    public IntKeyMap() {
        this(8);
    }

    private int nextIndex(int index, int length) {
        index = index >= length - 1 ? 0 : index + 1;
        return index;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static int index(int hashCode, int length) {
        return hashCode & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(int key) {
        int index;
        int length = this.table.length;
        int start = index = IntKeyMap.index(key, length);
        do {
            Entry<V> e;
            if ((e = this.table[index]) == null) {
                return null;
            }
            if (e.key != key) continue;
            return e.value;
        } while ((index = this.nextIndex(index, length)) != start);
        return null;
    }

    public boolean containsKey(int key) {
        int index;
        int length = this.table.length;
        int start = index = IntKeyMap.index(key, length);
        do {
            Entry<V> e;
            if ((e = this.table[index]) == null) {
                return false;
            }
            if (e.key != key) continue;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    public boolean containsValue(Object value) {
        for (Entry<V> e : this.table) {
            if (e == null || !IntKeyMap.eq(value, e.value)) continue;
            return true;
        }
        return false;
    }

    public V put(int key, V value) {
        Entry<V> e;
        int index;
        Entry<V>[] table = this.table;
        int hash = key;
        int length = table.length;
        int start = index = IntKeyMap.index(hash, length);
        while ((e = table[index]) != null) {
            if (e.key == key) {
                table[index] = new Entry<V>(key, value);
                return e.value;
            }
            if ((index = this.nextIndex(index, length)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        table[index] = new Entry<V>(key, value);
        if (++this.size >= this.threshold) {
            this.resize(length);
        }
        return null;
    }

    private void resize(int from) {
        Entry<V>[] old;
        int newLength = from << 1;
        if (newLength > 0x40000000 || newLength <= from) {
            return;
        }
        Entry[] newTable = new Entry[newLength];
        for (Entry<V> e : old = this.table) {
            if (e == null) continue;
            int index = IntKeyMap.index(e.key, newLength);
            while (newTable[index] != null) {
                index = this.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    public V remove(int key) {
        int start;
        Entry<V>[] table = this.table;
        int length = table.length;
        int index = start = IntKeyMap.index(key, length);
        do {
            Entry<V> e;
            if ((e = table[index]) == null) {
                return null;
            }
            if (e.key != key) continue;
            table[index] = null;
            this.relocate(index);
            --this.size;
            return e.value;
        } while ((index = this.nextIndex(index, length)) != start);
        return null;
    }

    private void relocate(int start) {
        Entry<V>[] table = this.table;
        int length = table.length;
        int current = this.nextIndex(start, length);
        Entry<V> e;
        while ((e = table[current]) != null) {
            int prefer = IntKeyMap.index(e.key, length);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = this.nextIndex(current, length);
        }
        return;
    }

    public void clear() {
        Entry<V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    public IntKeyMap<V> clone() {
        try {
            IntKeyMap clone = (IntKeyMap)super.clone();
            clone.table = (Entry[])this.table.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void printDebugStats() {
        int optimal = 0;
        int total = 0;
        int totalSkew = 0;
        int maxSkew = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry<V> e = this.table[i];
            if (e == null) continue;
            ++total;
            int target = IntKeyMap.index(e.key, this.table.length);
            if (i == target) {
                ++optimal;
                continue;
            }
            int skew = Math.abs(i - target);
            if (skew > maxSkew) {
                maxSkew = skew;
            }
            totalSkew += skew;
        }
        System.out.println(" Size:             " + this.size);
        System.out.println(" Real Size:        " + total);
        System.out.println(" Optimal:          " + optimal + " (" + (float)optimal * 100.0f / (float)total + "%)");
        System.out.println(" Average Distance: " + (float)totalSkew / (float)(total - optimal));
        System.out.println(" Max Distance:     " + maxSkew);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(size, this.loadFactor);
        for (int i = 0; i < size; ++i) {
            int key = s.readInt();
            Object value = s.readObject();
            this.putForCreate(key, value);
        }
        this.size = size;
    }

    private void putForCreate(int key, V value) {
        Entry<V>[] table = this.table;
        int length = table.length;
        int index = IntKeyMap.index(key, length);
        Entry<V> e = table[index];
        while (e != null) {
            index = this.nextIndex(index, length);
            e = table[index];
        }
        table[index] = new Entry<V>(key, value);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Entry<V> e : this.table) {
            if (e == null) continue;
            s.writeInt(e.key);
            s.writeObject(e.value);
        }
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return new Iterator<Entry<V>>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                Entry<V>[] table = IntKeyMap.this.table;
                int len = table.length;
                if (this.i == len) {
                    return false;
                }
                while (table[this.i] == null) {
                    if (++this.i != len) continue;
                    return false;
                }
                return false;
            }

            @Override
            public Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntKeyMap.this.table[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final class Entry<V> {
        private final int key;
        private final V value;

        private Entry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

