/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import jakarta.ejb.EJBHome;
import jakarta.ejb.NoSuchEJBException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.transaction.xa.XAException;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.ejb.Constants;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.InvocationIdentifier;
import org.wildfly.httpclient.ejb.RequestType;
import org.wildfly.httpclient.ejb.Serializer;
import org.wildfly.httpclient.ejb.TransactionInfo;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;

final class ServerHandlers {
    private final HttpServiceConfig config;
    private final Association association;
    private final ExecutorService executorService;
    private final LocalTransactionContext ctx;
    private final Function<String, Boolean> classFilter;
    private final Map<InvocationIdentifier, CancelHandle> cancellationFlags = new ConcurrentHashMap<InvocationIdentifier, CancelHandle>();

    private ServerHandlers(HttpServiceConfig config, Association association, ExecutorService executorService, LocalTransactionContext ctx, Function<String, Boolean> classFilter) {
        this.config = config;
        this.association = association;
        this.executorService = executorService;
        this.ctx = ctx;
        this.classFilter = classFilter;
    }

    static ServerHandlers newInstance(HttpServiceConfig config, Association association, ExecutorService executorService, LocalTransactionContext ctx, Function<String, Boolean> classFilter) {
        return new ServerHandlers(config, association, executorService, ctx, classFilter);
    }

    HttpHandler handlerOf(RequestType requestType) {
        switch (requestType) {
            case INVOKE: {
                return new HttpInvocationHandler(this.config, this.association, this.executorService, this.ctx, this.cancellationFlags, this.classFilter);
            }
            case CANCEL: {
                return new HttpCancelHandler(this.config, this.executorService, this.cancellationFlags);
            }
            case CREATE_SESSION: {
                return new HttpSessionOpenHandler(this.config, this.association, this.executorService, this.ctx);
            }
            case DISCOVER: {
                return new HttpDiscoveryHandler(this.config, this.executorService, this.association);
            }
        }
        throw new IllegalStateException();
    }

    private static abstract class AbstractEjbHandler
    implements HttpHandler {
        private final ExecutorService executorService;
        private static final AttachmentKey<ExecutorService> EXECUTOR = AttachmentKey.create(ExecutorService.class);

        public AbstractEjbHandler(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.isInIoThread()) {
                if (this.executorService == null) {
                    exchange.dispatch(this);
                } else {
                    exchange.putAttachment(EXECUTOR, this.executorService);
                    exchange.dispatch((Executor)this.executorService, this);
                }
                return;
            }
            if (this.executorService != null && exchange.getAttachment(EXECUTOR) == null) {
                exchange.putAttachment(EXECUTOR, this.executorService);
                exchange.dispatch((Executor)this.executorService, this);
                return;
            }
            exchange.startBlocking();
            this.handleInternal(exchange);
        }

        protected abstract void handleInternal(HttpServerExchange var1) throws Exception;

        protected static String handleDash(String s) {
            return "-".equals(s) ? "" : s;
        }
    }

    private static final class HttpDiscoveryHandler
    extends AbstractEjbHandler {
        private final Set<EJBModuleIdentifier> availableModules = new HashSet<EJBModuleIdentifier>();
        private final HttpServiceConfig config;

        public HttpDiscoveryHandler(HttpServiceConfig config, ExecutorService executorService, Association association) {
            super(executorService);
            this.config = config;
            association.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){

                @Override
                public void moduleAvailable(List<EJBModuleIdentifier> modules) {
                    availableModules.addAll(modules);
                }

                @Override
                public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
                    availableModules.removeAll(modules);
                }
            });
        }

        @Override
        protected void handleInternal(HttpServerExchange exchange) throws Exception {
            byte[] data;
            ByteOutput byteOutput;
            HeadersHelper.putResponseHeader(exchange, Headers.CONTENT_TYPE, Constants.EJB_DISCOVERY_RESPONSE);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Marshaller marshaller = this.config.getHttpMarshallerFactory(exchange).createMarshaller(HttpProtocolV1ObjectTable.INSTANCE);
            try (ByteOutput byteOutput2 = byteOutput = ByteOutputs.byteOutputOf(out);){
                marshaller.start(byteOutput);
                Serializer.serializeSet(marshaller, this.availableModules);
                marshaller.finish();
                data = out.toByteArray();
            }
            exchange.getResponseSender().send(ByteBuffer.wrap(data));
        }
    }

    private static final class HttpSessionOpenHandler
    extends AbstractEjbHandler {
        private final Association association;
        private final ExecutorService executorService;
        private final SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
        private final LocalTransactionContext localTransactionContext;
        private final HttpServiceConfig config;

        HttpSessionOpenHandler(HttpServiceConfig config, Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext) {
            super(executorService);
            this.config = config;
            this.association = association;
            this.executorService = executorService;
            this.localTransactionContext = localTransactionContext;
        }

        @Override
        protected void handleInternal(final HttpServerExchange exchange) throws Exception {
            String[] parts;
            String ct = HeadersHelper.getRequestHeader(exchange, Headers.CONTENT_TYPE);
            ContentType contentType = ContentType.parse(ct);
            if (contentType == null || contentType.getVersion() != 1 || !Constants.SESSION_OPEN.getType().equals(contentType.getType())) {
                exchange.setStatusCode(400);
                EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
                return;
            }
            String relativePath = exchange.getRelativePath();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if ((parts = relativePath.split("/")).length != 4) {
                exchange.setStatusCode(404);
                return;
            }
            String app = HttpSessionOpenHandler.handleDash(parts[0]);
            String module = HttpSessionOpenHandler.handleDash(parts[1]);
            String distinct = HttpSessionOpenHandler.handleDash(parts[2]);
            String bean = parts[3];
            Cookie cookie = exchange.getRequestCookie("JSESSIONID");
            String sessionAffinity = null;
            if (cookie != null) {
                sessionAffinity = cookie.getValue();
            }
            final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
            exchange.dispatch((Executor)this.executorService, () -> {
                LocalTransaction transaction;
                TransactionInfo txnInfo;
                try {
                    HttpMarshallerFactory httpUnmarshallerFactory = this.config.getHttpUnmarshallerFactory(exchange);
                    Unmarshaller unmarshaller = httpUnmarshallerFactory.createUnmarshaller(HttpProtocolV1ObjectTable.INSTANCE);
                    try (InputStream is = exchange.getInputStream();){
                        unmarshaller.start(ByteInputs.byteInputOf(is));
                        txnInfo = Serializer.deserializeTransaction(unmarshaller);
                        unmarshaller.finish();
                    }
                }
                catch (Exception e) {
                    HttpServerHelper.sendException(exchange, this.config, 500, e);
                    return;
                }
                if (txnInfo.getType() == TransactionInfo.NULL_TRANSACTION || this.localTransactionContext == null) {
                    transaction = null;
                } else {
                    try {
                        ImportResult<LocalTransaction> result = this.localTransactionContext.findOrImportTransaction(txnInfo.getXid(), txnInfo.getRemainingTime());
                        transaction = result.getTransaction();
                    }
                    catch (XAException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.association.receiveSessionOpenRequest(new SessionOpenRequest(){

                    @Override
                    public boolean hasTransaction() {
                        return txnInfo != null;
                    }

                    @Override
                    public Transaction getTransaction() throws SystemException, IllegalStateException {
                        return transaction;
                    }

                    @Override
                    public SocketAddress getPeerAddress() {
                        return exchange.getSourceAddress();
                    }

                    @Override
                    public SocketAddress getLocalAddress() {
                        return exchange.getDestinationAddress();
                    }

                    @Override
                    public Executor getRequestExecutor() {
                        return executorService != null ? executorService : exchange.getIoThread().getWorker();
                    }

                    @Override
                    public String getProtocol() {
                        return exchange.getProtocol().toString();
                    }

                    @Override
                    public boolean isBlockingCaller() {
                        return false;
                    }

                    @Override
                    public EJBIdentifier getEJBIdentifier() {
                        return ejbIdentifier;
                    }

                    @Override
                    public SecurityIdentity getSecurityIdentity() {
                        return exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                    }

                    @Override
                    public void writeException(@NotNull Exception exception) {
                        HttpServerHelper.sendException(exchange, config, 500, exception);
                    }

                    @Override
                    public void writeNoSuchEJB() {
                        HttpServerHelper.sendException(exchange, config, 404, new NoSuchEJBException());
                    }

                    @Override
                    public void writeWrongViewType() {
                        HttpServerHelper.sendException(exchange, config, 404, EjbHttpClientMessages.MESSAGES.wrongViewType());
                    }

                    @Override
                    public void writeCancelResponse() {
                        throw new RuntimeException("nyi");
                    }

                    @Override
                    public void writeNotStateful() {
                        HttpServerHelper.sendException(exchange, config, 500, EjbHttpClientMessages.MESSAGES.notStateful());
                    }

                    @Override
                    public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                        Cookie sessionCookie = exchange.getRequestCookie("JSESSIONID");
                        if (sessionCookie == null) {
                            String rootPath = exchange.getResolvedPath();
                            int ejbIndex = rootPath.lastIndexOf("/ejb");
                            if (ejbIndex > 0) {
                                rootPath = rootPath.substring(0, ejbIndex);
                            }
                            exchange.setResponseCookie(new CookieImpl("JSESSIONID", sessionIdGenerator.createSessionId()).setPath(rootPath));
                        }
                        HeadersHelper.putResponseHeader(exchange, Headers.CONTENT_TYPE, Constants.EJB_RESPONSE_NEW_SESSION);
                        HeadersHelper.putResponseHeader(exchange, Constants.EJB_SESSION_ID, Base64.getUrlEncoder().encodeToString(sessionId.getEncodedForm()));
                        exchange.setStatusCode(204);
                        exchange.endExchange();
                    }

                    @Override
                    public <C> C getProviderInterface(Class<C> providerInterfaceType) {
                        return null;
                    }
                });
            });
        }
    }

    private static final class HttpCancelHandler
    extends AbstractEjbHandler {
        private final Map<InvocationIdentifier, CancelHandle> cancellationFlags;

        HttpCancelHandler(HttpServiceConfig config, ExecutorService executorService, Map<InvocationIdentifier, CancelHandle> cancellationFlags) {
            super(executorService);
            this.cancellationFlags = cancellationFlags;
        }

        @Override
        protected void handleInternal(HttpServerExchange exchange) throws Exception {
            String sessionAffinity;
            String[] parts;
            String ct = HeadersHelper.getRequestHeader(exchange, Headers.CONTENT_TYPE);
            ContentType contentType = ContentType.parse(ct);
            if (contentType != null) {
                exchange.setStatusCode(400);
                EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
                return;
            }
            String relativePath = exchange.getRelativePath();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if ((parts = relativePath.split("/")).length != 6) {
                exchange.setStatusCode(404);
                return;
            }
            String app = HttpCancelHandler.handleDash(parts[0]);
            String module = HttpCancelHandler.handleDash(parts[1]);
            String distinct = HttpCancelHandler.handleDash(parts[2]);
            String bean = parts[3];
            String invocationId = parts[4];
            boolean cancelIdRunning = Boolean.parseBoolean(parts[5]);
            Cookie cookie = exchange.getRequestCookie("JSESSIONID");
            String string = sessionAffinity = cookie != null ? cookie.getValue() : null;
            if (invocationId == null || sessionAffinity == null) {
                exchange.setStatusCode(400);
                EjbHttpClientMessages.MESSAGES.debugf("Exchange %s did not include both session id and invocation id in cancel request", (Object)exchange);
                return;
            }
            InvocationIdentifier identifier = new InvocationIdentifier(invocationId, sessionAffinity);
            CancelHandle handle = this.cancellationFlags.remove(identifier);
            if (handle != null) {
                handle.cancel(cancelIdRunning);
            }
        }
    }

    static final class HttpInvocationHandler
    extends AbstractEjbHandler {
        private final Association association;
        private final ExecutorService executorService;
        private final LocalTransactionContext localTransactionContext;
        private final Map<InvocationIdentifier, CancelHandle> cancellationFlags;
        private final Function<String, Boolean> classResolverFilter;
        private final HttpServiceConfig config;

        HttpInvocationHandler(HttpServiceConfig config, Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Map<InvocationIdentifier, CancelHandle> cancellationFlags, Function<String, Boolean> classResolverFilter) {
            super(executorService);
            this.config = config;
            this.association = association;
            this.executorService = executorService;
            this.localTransactionContext = localTransactionContext;
            this.cancellationFlags = cancellationFlags;
            this.classResolverFilter = classResolverFilter;
        }

        @Override
        protected void handleInternal(final HttpServerExchange exchange) throws Exception {
            String[] parts;
            String ct = HeadersHelper.getRequestHeader(exchange, Headers.CONTENT_TYPE);
            ContentType contentType = ContentType.parse(ct);
            if (contentType == null || contentType.getVersion() != 1 || !Constants.INVOCATION.getType().equals(contentType.getType())) {
                exchange.setStatusCode(400);
                EjbHttpClientMessages.MESSAGES.debugf("Bad content type %s", (Object)ct);
                return;
            }
            String relativePath = exchange.getRelativePath();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if ((parts = relativePath.split("/")).length < 7) {
                exchange.setStatusCode(404);
                return;
            }
            final String app = HttpInvocationHandler.handleDash(parts[0]);
            final String module = HttpInvocationHandler.handleDash(parts[1]);
            final String distinct = HttpInvocationHandler.handleDash(parts[2]);
            final String bean = parts[3];
            String originalSessionId = HttpInvocationHandler.handleDash(parts[4]);
            final byte[] sessionID = originalSessionId.isEmpty() ? null : Base64.getUrlDecoder().decode(originalSessionId);
            final String viewName = parts[5];
            final String method = parts[6];
            final String[] parameterTypeNames = new String[parts.length - 7];
            System.arraycopy(parts, 7, parameterTypeNames, 0, parameterTypeNames.length);
            Cookie cookie = exchange.getRequestCookie("JSESSIONID");
            final String sessionAffinity = cookie != null ? cookie.getValue() : null;
            final EJBIdentifier ejbIdentifier = new EJBIdentifier(app, module, bean, distinct);
            String cancellationId = HeadersHelper.getRequestHeader(exchange, Constants.INVOCATION_ID);
            final InvocationIdentifier identifier = cancellationId != null && sessionAffinity != null ? new InvocationIdentifier(cancellationId, sessionAffinity) : null;
            exchange.dispatch((Executor)this.executorService, () -> {
                CancelHandle handle = this.association.receiveInvocationRequest(new InvocationRequest(){

                    @Override
                    public SocketAddress getPeerAddress() {
                        return exchange.getSourceAddress();
                    }

                    @Override
                    public SocketAddress getLocalAddress() {
                        return exchange.getDestinationAddress();
                    }

                    @Override
                    public InvocationRequest.Resolved getRequestContent(ClassLoader classLoader) throws IOException, ClassNotFoundException {
                        ResolvedInvocation resolvedInvocation;
                        block13: {
                            Class<?> view = Class.forName(viewName, false, classLoader);
                            HttpMarshallerFactory unmarshallingFactory = config.getHttpUnmarshallerFactory(exchange);
                            Unmarshaller unmarshaller = unmarshallingFactory.createUnmarshaller(new FilteringClassResolver(classLoader, classResolverFilter), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
                            InputStream is = exchange.getInputStream();
                            try {
                                LocalTransaction transaction;
                                unmarshaller.start(ByteInputs.byteInputOf(is));
                                TransactionInfo txnInfo = Serializer.deserializeTransaction(unmarshaller);
                                Object[] methodParams = new Object[parameterTypeNames.length];
                                Serializer.deserializeObjectArray(unmarshaller, methodParams);
                                Map<String, Object> contextData = Serializer.deserializeMap(unmarshaller);
                                unmarshaller.finish();
                                contextData.put("jboss.source-address", exchange.getConnection().getPeerAddress());
                                EJBLocator locator = EJBHome.class.isAssignableFrom(view) ? new EJBHomeLocator(view, app, module, bean, distinct, Affinity.LOCAL) : (sessionID != null ? new StatefulEJBLocator(view, app, module, bean, distinct, SessionID.createSessionID(sessionID), Affinity.LOCAL) : new StatelessEJBLocator(view, app, module, bean, distinct, Affinity.LOCAL));
                                HttpMarshallerFactory marshallerFactory = config.getHttpMarshallerFactory(exchange);
                                Marshaller marshaller = marshallerFactory.createMarshaller(new FilteringClassResolver(classLoader, classResolverFilter), (ObjectTable)HttpProtocolV1ObjectTable.INSTANCE);
                                if (txnInfo.getType() == TransactionInfo.NULL_TRANSACTION || localTransactionContext == null) {
                                    transaction = null;
                                } else {
                                    try {
                                        ImportResult<LocalTransaction> result = localTransactionContext.findOrImportTransaction(txnInfo.getXid(), txnInfo.getRemainingTime());
                                        transaction = result.getTransaction();
                                    }
                                    catch (XAException e) {
                                        throw new IllegalStateException(e);
                                    }
                                }
                                resolvedInvocation = new ResolvedInvocation(contextData, methodParams, locator, exchange, marshaller, sessionAffinity, transaction, identifier);
                                if (is == null) break block13;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException | ClassNotFoundException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    throw new IOException(e);
                                }
                            }
                            is.close();
                        }
                        return resolvedInvocation;
                    }

                    @Override
                    public EJBMethodLocator getMethodLocator() {
                        return new EJBMethodLocator(method, parameterTypeNames);
                    }

                    @Override
                    public void writeNoSuchMethod() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 404, EjbHttpClientMessages.MESSAGES.noSuchMethod());
                    }

                    @Override
                    public void writeSessionNotActive() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 500, EjbHttpClientMessages.MESSAGES.sessionNotActive());
                    }

                    @Override
                    public void writeWrongViewType() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 404, EjbHttpClientMessages.MESSAGES.wrongViewType());
                    }

                    @Override
                    public Executor getRequestExecutor() {
                        return executorService == null ? exchange.getIoThread().getWorker() : executorService;
                    }

                    @Override
                    public String getProtocol() {
                        return exchange.getProtocol().toString();
                    }

                    @Override
                    public boolean isBlockingCaller() {
                        return false;
                    }

                    @Override
                    public EJBIdentifier getEJBIdentifier() {
                        return ejbIdentifier;
                    }

                    @Override
                    public SecurityIdentity getSecurityIdentity() {
                        return exchange.getAttachment(ElytronIdentityHandler.IDENTITY_KEY);
                    }

                    @Override
                    public void writeException(@NotNull Exception exception) {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 500, exception);
                    }

                    @Override
                    public void writeNoSuchEJB() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 404, new NoSuchEJBException());
                    }

                    @Override
                    public void writeCancelResponse() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                    }

                    @Override
                    public void writeNotStateful() {
                        if (identifier != null) {
                            cancellationFlags.remove(identifier);
                        }
                        HttpServerHelper.sendException(exchange, config, 500, EjbHttpClientMessages.MESSAGES.notStateful());
                    }

                    @Override
                    public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
                        throw new RuntimeException("nyi");
                    }
                });
                if (handle != null && identifier != null) {
                    this.cancellationFlags.put(identifier, handle);
                }
            });
        }

        private static class FilteringClassResolver
        extends SimpleClassResolver {
            private final Function<String, Boolean> classResolverFilter;

            FilteringClassResolver(ClassLoader classLoader, Function<String, Boolean> classResolverFilter) {
                super(classLoader);
                this.classResolverFilter = classResolverFilter;
            }

            @Override
            public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
                this.checkFilter(name);
                return super.resolveClass(unmarshaller, name, serialVersionUID);
            }

            @Override
            public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
                for (String name : interfaces) {
                    this.checkFilter(name);
                }
                return super.resolveProxyClass(unmarshaller, interfaces);
            }

            private void checkFilter(String className) throws InvalidClassException {
                if (this.classResolverFilter != null && this.classResolverFilter.apply(className) != Boolean.TRUE) {
                    throw EjbHttpClientMessages.MESSAGES.cannotResolveFilteredClass(className);
                }
            }
        }

        class ResolvedInvocation
        implements InvocationRequest.Resolved {
            private final Map<String, Object> contextData;
            private final Object[] methodParams;
            private final EJBLocator<?> locator;
            private final HttpServerExchange exchange;
            private final Marshaller marshaller;
            private final String sessionAffinity;
            private final Transaction transaction;
            private final InvocationIdentifier identifier;

            public ResolvedInvocation(Map<String, Object> contextData, Object[] methodParams, EJBLocator<?> locator, HttpServerExchange exchange, Marshaller marshaller, String sessionAffinity, Transaction transaction, InvocationIdentifier identifier) {
                this.contextData = contextData;
                this.methodParams = methodParams;
                this.locator = locator;
                this.exchange = exchange;
                this.marshaller = marshaller;
                this.sessionAffinity = sessionAffinity;
                this.transaction = transaction;
                this.identifier = identifier;
            }

            @Override
            public Map<String, Object> getAttachments() {
                return this.contextData;
            }

            @Override
            public Object[] getParameters() {
                return this.methodParams;
            }

            @Override
            public EJBLocator<?> getEJBLocator() {
                return this.locator;
            }

            @Override
            public boolean hasTransaction() {
                return this.transaction != null;
            }

            @Override
            public Transaction getTransaction() throws SystemException, IllegalStateException {
                return this.transaction;
            }

            String getSessionAffinity() {
                return this.sessionAffinity;
            }

            HttpServerExchange getExchange() {
                return this.exchange;
            }

            @Override
            public void writeInvocationResult(Object result) {
                if (this.identifier != null) {
                    HttpInvocationHandler.this.cancellationFlags.remove(this.identifier);
                }
                try {
                    HeadersHelper.putResponseHeader(this.exchange, Headers.CONTENT_TYPE, Constants.EJB_RESPONSE);
                    try (ByteOutput out = ByteOutputs.byteOutputOf(this.exchange.getOutputStream());){
                        this.marshaller.start(out);
                        Serializer.serializeObject(this.marshaller, result);
                        Serializer.serializeMap(this.marshaller, this.contextData);
                        this.marshaller.finish();
                    }
                    this.exchange.endExchange();
                }
                catch (Exception e) {
                    HttpServerHelper.sendException(this.exchange, HttpInvocationHandler.this.config, 500, e);
                }
            }
        }
    }
}

