/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class SecurityUtils {
    private SecurityUtils() {
    }

    static int getSystemProperty(String propertyName, int defaultValue) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetSystemPropertyAction(propertyName, defaultValue));
        }
        return Integer.getInteger(propertyName, defaultValue);
    }

    static ClassLoader getCL(Class<?> clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetCLAction(clazz));
        }
        return clazz.getClassLoader();
    }

    static ClassLoader setTCCL(ClassLoader newTCCL) {
        SetTCCLAction setTCCLAction = new SetTCCLAction(newTCCL);
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(setTCCLAction);
        }
        return setTCCLAction.run();
    }

    static Field getClassField(Class clazz, String fieldName) {
        GetFieldAction getFieldAction = new GetFieldAction(clazz, fieldName);
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(getFieldAction);
        }
        return getFieldAction.run();
    }

    private static final class GetCLAction
    implements PrivilegedAction<ClassLoader> {
        private final Class clazz;

        GetCLAction(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    private static final class GetSystemPropertyAction
    implements PrivilegedAction<Integer> {
        private final String propertyName;
        private final int defaultValue;

        GetSystemPropertyAction(String propertyName, int defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public Integer run() {
            return Integer.getInteger(this.propertyName, this.defaultValue);
        }
    }

    private static final class GetFieldAction
    implements PrivilegedAction<Field> {
        private final Class clazz;
        private final String fieldName;

        GetFieldAction(Class clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
        }

        @Override
        public Field run() {
            Field field;
            try {
                field = this.clazz.getDeclaredField(this.fieldName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            field.setAccessible(true);
            return field;
        }
    }

    private static final class SetTCCLAction
    implements PrivilegedAction<ClassLoader> {
        private final ClassLoader classLoader;

        SetTCCLAction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader run() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader;
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.classLoader);
            }
        }
    }
}

