/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import org.glassfish.enterprise.concurrent.spi.TransactionHandle;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ServiceTransactionSetupProvider
implements TransactionSetupProvider {
    private transient TransactionSetupProvider transactionSetupProvider;
    private final ServiceName serviceName;

    public ServiceTransactionSetupProvider(TransactionSetupProvider transactionSetupProvider, ServiceName serviceName) {
        this.transactionSetupProvider = transactionSetupProvider;
        this.serviceName = serviceName;
    }

    public TransactionHandle beforeProxyMethod(String transactionExecutionProperty) {
        return this.transactionSetupProvider.beforeProxyMethod(transactionExecutionProperty);
    }

    public void afterProxyMethod(TransactionHandle handle, String transactionExecutionProperty) {
        this.transactionSetupProvider.afterProxyMethod(handle, transactionExecutionProperty);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ServiceContainer currentServiceContainer = System.getSecurityManager() == null ? CurrentServiceContainer.getServiceContainer() : (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
        ServiceController serviceController = currentServiceContainer.getService(this.serviceName);
        if (serviceController == null) {
            throw EeLogger.ROOT_LOGGER.transactionSetupProviderServiceNotInstalled();
        }
        this.transactionSetupProvider = (TransactionSetupProvider)serviceController.getValue();
    }
}

