/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.access.InVmAccess;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static boolean isInVmCall() {
        return SecurityActions.createInVmActions().isInVmCall();
    }

    static <T> T runInVm(PrivilegedAction<T> action) {
        return SecurityActions.createInVmActions().runInVm(action);
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return WildFlySecurityManager.isChecking() ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static InVmActions createInVmActions() {
        return WildFlySecurityManager.isChecking() ? InVmActions.PRIVILEGED : InVmActions.NON_PRIVILEGED;
    }

    private static interface InVmActions {
        public static final InVmActions NON_PRIVILEGED = new InVmActions(){

            @Override
            public <T> T runInVm(PrivilegedAction<T> action) {
                return InVmAccess.runInVm(action);
            }

            @Override
            public boolean isInVmCall() {
                return InVmAccess.isInVmCall();
            }
        };
        public static final InVmActions PRIVILEGED = new InVmActions(){

            @Override
            public <T> T runInVm(PrivilegedAction<T> action) {
                return (T)AccessController.doPrivileged(() -> InVmAccess.runInVm(action));
            }

            @Override
            public boolean isInVmCall() {
                return AccessController.doPrivileged(NON_PRIVILEGED::isInVmCall);
            }
        };

        public boolean isInVmCall();

        public <T> T runInVm(PrivilegedAction<T> var1);
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }
}

