/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;

final class Reflect {
    Reflect() {
    }

    static Field findField(final Class<?> sourceClass, final Class<?> fieldType) {
        if (System.getSecurityManager() == null) {
            return Reflect.findFieldUnchecked(sourceClass, fieldType);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                return Reflect.findFieldUnchecked(sourceClass, fieldType);
            }
        });
    }

    private static Field findFieldUnchecked(Class<?> sourceClass, Class<?> fieldType) {
        Class<?> type;
        Field[] fields;
        LinkedList<Field> assignableFields = new LinkedList<Field>();
        for (Field field : fields = sourceClass.getDeclaredFields()) {
            type = field.getType();
            if (Modifier.isStatic(field.getModifiers()) || type != fieldType) continue;
            assignableFields.add(field);
        }
        if (assignableFields.isEmpty()) {
            for (Field field : fields) {
                type = field.getType();
                if (Modifier.isStatic(field.getModifiers()) || type == Object.class || !type.isAssignableFrom(fieldType)) continue;
                assignableFields.add(field);
            }
        }
        if (assignableFields.size() > 1) {
            throw new IllegalStateException(((Object)assignableFields).toString());
        }
        if (!assignableFields.isEmpty()) {
            Field field = (Field)assignableFields.get(0);
            field.setAccessible(true);
            return field;
        }
        Class<?> superClass = sourceClass.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            throw new IllegalArgumentException(fieldType.getName());
        }
        return Reflect.findFieldUnchecked(superClass, fieldType);
    }

    static Method findMethod(final Class<?> sourceClass, final Class<?> returnType) {
        if (System.getSecurityManager() == null) {
            return Reflect.findMethodUnchecked(sourceClass, returnType);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                return Reflect.findMethodUnchecked(sourceClass, returnType);
            }
        });
    }

    private static Method findMethodUnchecked(Class<?> sourceClass, Class<?> returnType) {
        LinkedList<Method> matchingMethods = new LinkedList<Method>();
        for (Method method : sourceClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType() != returnType) continue;
            matchingMethods.add(method);
        }
        if (matchingMethods.size() > 1) {
            throw new IllegalStateException(((Object)matchingMethods).toString());
        }
        if (!matchingMethods.isEmpty()) {
            Method method = (Method)matchingMethods.get(0);
            method.setAccessible(true);
            return method;
        }
        Class<?> superClass = sourceClass.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            throw new IllegalArgumentException(returnType.getName());
        }
        return Reflect.findMethodUnchecked(superClass, returnType);
    }

    static Method findMethod(final Class<?> sourceClass, final String methodName) {
        if (System.getSecurityManager() == null) {
            return Reflect.findMethodUnchecked(sourceClass, methodName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                return Reflect.findMethodUnchecked(sourceClass, methodName);
            }
        });
    }

    private static Method findMethodUnchecked(Class<?> sourceClass, String methodName) {
        try {
            Method method = sourceClass.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    static <T> Constructor<T> getConstructor(final Class<T> sourceClass, final Class<?> ... parameterTypes) {
        if (System.getSecurityManager() == null) {
            return Reflect.getConstructorUnchecked(sourceClass, parameterTypes);
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                return Reflect.getConstructorUnchecked(sourceClass, parameterTypes);
            }
        });
    }

    private static <T> Constructor<T> getConstructorUnchecked(Class<T> sourceClass, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = sourceClass.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    static <T> T newInstance(final Constructor<T> constructor, final Object ... parameters) {
        if (System.getSecurityManager() == null) {
            return Reflect.newInstanceUnchecked(constructor, parameters);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return Reflect.newInstanceUnchecked(constructor, parameters);
            }
        });
    }

    private static <T> T newInstanceUnchecked(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static Object getValue(Object source, Field field) {
        return Reflect.getValue(source, field, Object.class);
    }

    static <T> T getValue(final Object source, final Field field, final Class<T> fieldType) {
        if (System.getSecurityManager() == null) {
            return Reflect.getValueUnchecked(source, field, fieldType);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return Reflect.getValueUnchecked(source, field, fieldType);
            }
        });
    }

    private static <T> T getValueUnchecked(Object source, Field field, Class<T> fieldType) {
        try {
            return fieldType.cast(field.get(source));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static void setValue(final Object source, final Field field, final Object value) {
        if (System.getSecurityManager() == null) {
            Reflect.setValueUnchecked(source, field, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    Reflect.setValueUnchecked(source, field, value);
                    return null;
                }
            });
        }
    }

    private static void setValueUnchecked(Object source, Field field, Object value) {
        try {
            field.set(source, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static Object invoke(Object source, Method method) {
        return Reflect.invoke(source, method, Object.class);
    }

    static <T> T invoke(final Object source, final Method method, final Class<T> returnClass) {
        if (System.getSecurityManager() == null) {
            return Reflect.invokeUnchecked(source, method, returnClass);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return Reflect.invokeUnchecked(source, method, returnClass);
            }
        });
    }

    private static <T> T invokeUnchecked(Object source, Method method, Class<T> returnClass) {
        try {
            return returnClass.cast(method.invoke(source, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

