/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.impl;

import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;

public final class Murmur3HashFunction
implements RangeCompatibleHashFunction {
    public static final Murmur3HashFunction INSTANCE = new Murmur3HashFunction(0);
    private static final int BYTES_PER_CHAR = 2;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    private Murmur3HashFunction(int seed) {
        this.seed = seed;
    }

    public String toString() {
        return "Murmur3HashFunction(" + this.seed + ")";
    }

    @Override
    public int hash(CharSequence input) {
        int h1 = this.seed;
        for (int i = 1; i < input.length(); i += 2) {
            int k1 = input.charAt(i - 1) | input.charAt(i) << 16;
            k1 = Murmur3HashFunction.mixK1(k1);
            h1 = Murmur3HashFunction.mixH1(h1, k1);
        }
        if ((input.length() & 1) == 1) {
            int k1 = input.charAt(input.length() - 1);
            k1 = Murmur3HashFunction.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3HashFunction.fmix(h1, 2 * input.length());
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

