/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.VersionedMetadata;
import org.infinispan.client.hotrod.impl.operations.GetStreamNextResponse;
import org.infinispan.client.hotrod.impl.protocol.AbstractVersionedInputStream;

public class GetInputStream
extends AbstractVersionedInputStream {
    private final BlockingQueue<ByteBuf> bufs = new ArrayBlockingQueue<ByteBuf>(1);
    private final Supplier<CompletionStage<GetStreamNextResponse>> valueSupplier;
    private final Runnable onClose;
    private ByteBuf currentBuffer;
    private volatile boolean complete;
    private volatile Throwable throwable;

    public GetInputStream(Supplier<CompletionStage<GetStreamNextResponse>> valueSupplier, VersionedMetadata versionedMetadata, ByteBuf initial, boolean complete, Runnable onClose) {
        super(versionedMetadata);
        this.valueSupplier = valueSupplier;
        this.onClose = onClose;
        this.currentBuffer = initial;
        this.complete = complete;
        if (!complete) {
            this.sendRequestForMore();
        }
    }

    private void sendRequestForMore() {
        this.valueSupplier.get().whenComplete((bb, t) -> {
            if (t != null) {
                this.throwable = t;
                this.bufs.add(Unpooled.EMPTY_BUFFER);
                return;
            }
            if (bb.complete()) {
                this.complete = true;
            }
            this.bufs.add(bb.value());
        });
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.throwable != null) {
            throw new IOException(this.throwable);
        }
        if (this.currentBuffer != null) {
            if (this.currentBuffer.isReadable()) {
                return this.currentBuffer.readUnsignedByte();
            }
            this.currentBuffer.release();
        }
        if (this.complete && this.bufs.isEmpty()) {
            return -1;
        }
        try {
            this.currentBuffer = this.retrieveNext();
            return this.read();
        }
        catch (InterruptedException e) {
            IOException ioException = new IOException(e);
            if (this.throwable != null) {
                ioException.addSuppressed(this.throwable);
            }
            throw ioException;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.throwable != null) {
            throw new IOException(this.throwable);
        }
        int numRead = 0;
        try {
            int readAmount;
            if (this.currentBuffer == null) {
                if (this.complete && this.bufs.isEmpty()) {
                    return -1;
                }
                this.currentBuffer = this.retrieveNext();
                if (this.throwable != null) {
                    throw new IOException(this.throwable);
                }
            }
            if (this.currentBuffer.isReadable()) {
                readAmount = Math.min(len, this.currentBuffer.readableBytes());
                this.currentBuffer.readBytes(b, off, readAmount);
                if (readAmount == len) {
                    return readAmount;
                }
                numRead += readAmount;
            }
            if (!this.currentBuffer.isReadable()) {
                this.currentBuffer.release();
                this.currentBuffer = null;
                if (this.complete && this.bufs.isEmpty()) {
                    return numRead > 0 ? numRead : -1;
                }
            }
            this.currentBuffer = (ByteBuf)this.bufs.poll();
            if (this.currentBuffer != null) {
                this.sendRequestForMore();
                readAmount = Math.min(len - numRead, this.currentBuffer.readableBytes());
                this.currentBuffer.readBytes(b, off, readAmount);
                numRead += readAmount;
            }
            return numRead;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized ByteBuf retrieveNext() throws InterruptedException {
        ByteBuf buf = this.bufs.take();
        if (!this.complete && buf != Unpooled.EMPTY_BUFFER) {
            this.sendRequestForMore();
        }
        return buf;
    }

    @Override
    public void close() throws IOException {
        ByteBuf buf;
        this.complete = true;
        while ((buf = (ByteBuf)this.bufs.poll()) != null) {
            buf.release();
        }
        this.bufs.add(Unpooled.EMPTY_BUFFER);
        this.onClose.run();
    }
}

