/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Function;
import org.jboss.as.clustering.controller.AbstractCapabilityReference;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.SimpleCapabilityNameResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class ResourceCapabilityReference
extends AbstractCapabilityReference {
    private final Function<PathAddress, String[]> requirementNameResolver;

    public ResourceCapabilityReference(Capability capability, Requirement requirement) {
        this(capability, requirement, SimpleCapabilityNameResolver.EMPTY);
    }

    public ResourceCapabilityReference(Capability capability, UnaryRequirement requirement, UnaryCapabilityNameResolver requirementNameResolver) {
        this(capability, (Requirement)requirement, (Function<PathAddress, String[]>)requirementNameResolver);
    }

    public ResourceCapabilityReference(Capability capability, BinaryRequirement requirement, BinaryCapabilityNameResolver requirementNameResolver) {
        this(capability, (Requirement)requirement, (Function<PathAddress, String[]>)requirementNameResolver);
    }

    private ResourceCapabilityReference(Capability capability, Requirement requirement, Function<PathAddress, String[]> requirementNameResolver) {
        super(capability, requirement);
        this.requirementNameResolver = requirementNameResolver;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        context.registerAdditionalCapabilityRequirement(this.getRequirementName(context), this.getDependentName(context), attributeName);
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        context.deregisterCapabilityRequirement(this.getRequirementName(context), this.getDependentName(context));
    }

    private String getRequirementName(OperationContext context) {
        String[] parts = this.requirementNameResolver.apply(context.getCurrentAddress());
        return parts.length > 0 ? RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String[])parts) : this.getBaseRequirementName();
    }

    public String[] getRequirementPatternSegments(String name, PathAddress address) {
        String[] segments = this.requirementNameResolver.apply(address);
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            if (segment.charAt(0) != '$') continue;
            segments[i] = segment.substring(1);
        }
        return segments;
    }
}

