/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.ha.PrimaryOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPRedistributeClusterTest
extends AmqpTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String QUEUE_NAME = "REDIST_QUEUE";
    private static final String TOPIC_NAME = "REDIST_TOPIC";
    private static final SimpleString TOPIC_NAME_SIMPLE_STRING = SimpleString.of((String)"REDIST_TOPIC");
    protected static final int A_1_PORT = 5673;
    protected static final int A_2_PORT = 5674;
    ActiveMQServer a1;
    ActiveMQServer a2;
    protected static final int B_1_PORT = 5773;
    protected static final int B_2_PORT = 5774;
    ActiveMQServer b1;
    ActiveMQServer b2;

    @BeforeEach
    public void setCluster() throws Exception {
        this.a1 = this.createClusteredServer("A_1", 5673, 5674, 5773);
        this.a2 = this.createClusteredServer("A_2", 5674, 5673, 5774);
        this.a1.start();
        this.a2.start();
        this.b1 = this.createClusteredServer("B_1", 5773, 5774, -1);
        this.b2 = this.createClusteredServer("B_2", 5774, 5773, -1);
        this.b1.start();
        this.b2.start();
    }

    private ActiveMQServer createClusteredServer(String name, int thisPort, int clusterPort, int mirrorPort) throws Exception {
        ActiveMQServer server = this.createServer(thisPort, false);
        server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(QUEUE_NAME).addRoutingType(RoutingType.ANYCAST).addQueueConfig(QueueConfiguration.of((String)QUEUE_NAME).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST)));
        server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(TOPIC_NAME).addRoutingType(RoutingType.MULTICAST));
        server.getConfiguration().clearAddressSettings();
        server.getConfiguration().addAddressSetting("#", new AddressSettings().setRedistributionDelay(0L));
        server.setIdentity(name);
        server.getConfiguration().setName("node").setHAPolicyConfiguration((HAPolicyConfiguration)new PrimaryOnlyPolicyConfiguration()).addConnectorConfiguration("thisNode", "tcp://localhost:" + thisPort).addConnectorConfiguration("otherNode", "tcp://localhost:" + clusterPort);
        ClusterConnectionConfiguration clusterConfiguration = new ClusterConnectionConfiguration().setName("cluster").setConnectorName("thisNode").setMessageLoadBalancingType(MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION).setStaticConnectors(Collections.singletonList("otherNode"));
        server.getConfiguration().addClusterConfiguration(clusterConfiguration);
        if (mirrorPort > 0) {
            server.getConfiguration().addAMQPConnection(new AMQPBrokerConnectConfiguration("myMirror" + mirrorPort, "tcp://localhost:" + mirrorPort).setReconnectAttempts(-1).setRetryInterval(100).addConnectionElement(new AMQPMirrorBrokerConnectionElement().setDurable(true).setMirrorSNF(SimpleString.of((String)this.mirrorName(mirrorPort)))));
        }
        return server;
    }

    private String mirrorName(int mirrorPort) {
        return "$ACTIVEMQ_ARTEMIS_MIRROR_MirrorTowards_" + mirrorPort;
    }

    @Test
    public void testQueueRedistributionAMQP() throws Exception {
        this.internalQueueRedistribution("AMQP");
    }

    @Test
    public void testQueueRedistributionCORE() throws Exception {
        this.internalQueueRedistribution("CORE");
    }

    public void internalQueueRedistribution(String protocol) throws Exception {
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        ConnectionFactory cfA1 = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5673");
        ConnectionFactory cfA2 = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5674");
        try (Connection conn = cfA1.createConnection();){
            Session session = conn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session.createTextMessage("Hello" + i));
            }
        }
        try (Connection connA1 = cfA1.createConnection();
             Connection connA2 = cfA2.createConnection();){
            connA1.start();
            connA2.start();
            Session sessionA1 = connA1.createSession(false, 1);
            Session sessionA2 = connA2.createSession(false, 1);
            for (int i = 0; i < 100; ++i) {
                MessageConsumer consumer;
                String place;
                if (i % 2 == 0) {
                    place = "A1";
                    consumer = sessionA1.createConsumer((Destination)sessionA1.createQueue(QUEUE_NAME));
                } else {
                    place = "A2";
                    consumer = sessionA2.createConsumer((Destination)sessionA2.createQueue(QUEUE_NAME));
                }
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                logger.debug("Received message {} from {}", (Object)message, (Object)place);
                consumer.close();
            }
        }
        this.assertEmptyQueue(this.a1.locateQueue(QUEUE_NAME));
        this.assertEmptyQueue(this.a2.locateQueue(QUEUE_NAME));
        this.assertEmptyQueue(this.b1.locateQueue(QUEUE_NAME));
        this.assertEmptyQueue(this.b2.locateQueue(QUEUE_NAME));
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222196"}));
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224037"}));
    }

    @Test
    public void testTopicRedistributionAMQP() throws Exception {
        this.internalTopicRedistribution("AMQP");
    }

    @Test
    public void testTopicRedistributionCORE() throws Exception {
        this.internalTopicRedistribution("CORE");
    }

    public void internalTopicRedistribution(String protocol) throws Exception {
        MessageConsumer consumer;
        Topic topic;
        Session session;
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        int numMessages = 100;
        String subscriptionName = "my-topic-shared-subscription";
        ConnectionFactory cfA1 = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5673");
        ConnectionFactory cfA2 = CFUtil.createConnectionFactory(protocol, "tcp://localhost:5674");
        try (Connection conn = cfA1.createConnection();){
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            consumer = session.createSharedDurableConsumer(topic, subscriptionName);
            consumer.close();
        }
        conn = cfA2.createConnection();
        try {
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            consumer = session.createSharedDurableConsumer(topic, subscriptionName);
            consumer.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertTrue(() -> this.a1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 2);
        Wait.assertTrue(() -> this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 2);
        Wait.assertTrue(() -> this.b1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 2);
        Wait.assertTrue(() -> this.b2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 2);
        HashSet subscriptionSet = new HashSet();
        this.a1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).forEach((n, b) -> {
            logger.debug("{} = {}", n, b);
            if (b instanceof LocalQueueBinding) {
                QueueBinding qb = (QueueBinding)b;
                subscriptionSet.add(qb.getUniqueName().toString());
                Wait.assertTrue(() -> this.b1.locateQueue(qb.getUniqueName()) != null);
            }
        });
        Assertions.assertEquals((int)1, (int)subscriptionSet.size());
        String subscriptionQueueName = (String)subscriptionSet.iterator().next();
        this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).forEach((n, b) -> {
            logger.debug("{} = {}", n, b);
            if (b instanceof LocalQueueBinding) {
                QueueBinding qb = (QueueBinding)b;
                Wait.assertTrue(() -> this.b2.locateQueue(qb.getUniqueName()) != null);
            }
        });
        Queue a1TopicSubscription = this.a1.locateQueue(subscriptionQueueName);
        Assertions.assertNotNull((Object)a1TopicSubscription);
        Queue a2TopicSubscription = this.a2.locateQueue(subscriptionQueueName);
        Assertions.assertNotNull((Object)a2TopicSubscription);
        Queue b1TopicSubscription = this.b1.locateQueue(subscriptionQueueName);
        Assertions.assertNotNull((Object)b1TopicSubscription);
        Queue b2TopicSubscription = this.b2.locateQueue(subscriptionQueueName);
        Assertions.assertNotNull((Object)this.a2);
        try (Connection conn = cfA1.createConnection();){
            Session session2 = conn.createSession(false, 1);
            MessageProducer producer = session2.createProducer((Destination)topic);
            for (int i = 0; i < 100; ++i) {
                producer.send((Message)session2.createTextMessage("Hello" + i));
            }
        }
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222196"}));
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224037"}));
        Assertions.assertEquals((int)0, (int)a1TopicSubscription.getConsumerCount());
        Wait.assertEquals((long)50L, () -> ((Queue)a1TopicSubscription).getMessageCount());
        Wait.assertEquals((long)50L, () -> ((Queue)a2TopicSubscription).getMessageCount());
        logger.debug("b1={}. b2={}", (Object)b1TopicSubscription.getMessageCount(), (Object)b2TopicSubscription.getMessageCount());
        Wait.assertEquals((long)50L, () -> ((Queue)b1TopicSubscription).getMessageCount());
        Wait.assertEquals((long)50L, () -> ((Queue)b2TopicSubscription).getMessageCount());
        try (Connection connA1 = cfA1.createConnection();
             Connection connA2 = cfA2.createConnection();){
            connA1.start();
            connA2.start();
            Session sessionA1 = connA1.createSession(false, 1);
            Session sessionA2 = connA2.createSession(false, 1);
            for (int i = 0; i < 100; ++i) {
                MessageConsumer consumer2;
                String place;
                if (i % 2 == 0) {
                    place = "A1";
                    consumer2 = sessionA1.createSharedDurableConsumer(topic, subscriptionName);
                } else {
                    place = "A2";
                    consumer2 = sessionA2.createSharedDurableConsumer(topic, subscriptionName);
                }
                TextMessage message = (TextMessage)consumer2.receive(5000L);
                Assertions.assertNotNull((Object)message);
                logger.debug("Received message {} from {}", (Object)message, (Object)place);
                consumer2.close();
            }
        }
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222196"}));
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224037"}));
        this.assertEmptyQueue(a1TopicSubscription);
        this.assertEmptyQueue(a2TopicSubscription);
        this.assertEmptyQueue(b1TopicSubscription);
        this.assertEmptyQueue(b2TopicSubscription);
    }

    @Test
    public void testRemoteBindingRouting() throws Exception {
        int i;
        Topic topic;
        Session session;
        String protocol = "AMQP";
        String subscriptionName = "my-topic-shared-subscription";
        ConnectionFactory cfA1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        ConnectionFactory cfA2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5674");
        try (Connection conn = cfA1.createConnection();){
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i = 0; i < 10; ++i) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i);
            }
        }
        conn = cfA2.createConnection();
        try {
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i = 0; i < 10; ++i) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertTrue(() -> this.a1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        ArrayList remoteQueueBindings_a2 = new ArrayList();
        this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).forEach((a, b) -> {
            if (b instanceof RemoteQueueBindingImpl && b.getClusterName().toString().startsWith(subscriptionName + "_0")) {
                logger.debug("{} = {}", a, b);
                remoteQueueBindings_a2.add((RemoteQueueBinding)b);
            }
        });
        Assertions.assertEquals((int)1, (int)remoteQueueBindings_a2.size());
        RoutingContextImpl routingContext = new RoutingContextImpl((Transaction)new TransactionImpl(this.a2.getStorageManager())).setMirrorOption(RoutingContext.MirrorOption.individualRoute);
        CoreMessage directMessage = new CoreMessage(this.a2.getStorageManager().generateID(), 512);
        directMessage.setAddress(TOPIC_NAME);
        directMessage.putStringProperty("Test", "t1");
        ((RemoteQueueBinding)remoteQueueBindings_a2.get(0)).route((org.apache.activemq.artemis.api.core.Message)directMessage, (RoutingContext)routingContext);
        this.a2.getPostOffice().processRoute((org.apache.activemq.artemis.api.core.Message)directMessage, (RoutingContext)routingContext, false);
        routingContext.getTransaction().commit();
        for (int i2 = 0; i2 < 10; ++i2) {
            String name = "my-topic-shared-subscription_" + i2 + ":global";
            if (logger.isDebugEnabled()) {
                logger.debug("a1 queue {} with {} messages", (Object)name, (Object)this.a1.locateQueue(name).getMessageCount());
                logger.debug("b1 queue {} with {} messages", (Object)name, (Object)this.b1.locateQueue(name).getMessageCount());
                logger.debug("a2 queue {} with {} messages", (Object)name, (Object)this.a2.locateQueue(name).getMessageCount());
                logger.debug("b2 queue {} with {} messages", (Object)name, (Object)this.b2.locateQueue(name).getMessageCount());
            }
            Wait.assertEquals((long)(i2 == 0 ? 1L : 0L), () -> ((Queue)this.a1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)(i2 == 0 ? 1L : 0L), () -> ((Queue)this.b1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.a2.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.b2.locateQueue(name)).getMessageCount());
        }
    }

    @Test
    public void testFakeMirrorSend() throws Exception {
        int i;
        Topic topic;
        Session session;
        String protocol = "AMQP";
        String subscriptionName = "my-topic-shared-subscription";
        ConnectionFactory cfA1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        ConnectionFactory cfA2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5674");
        try (Connection conn = cfA1.createConnection();){
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i = 0; i < 10; ++i) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i);
            }
        }
        conn = cfA2.createConnection();
        try {
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i = 0; i < 10; ++i) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertTrue(() -> this.a1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        ArrayList remoteQueueBindings_a2 = new ArrayList();
        this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).forEach((a, b) -> {
            if (b instanceof RemoteQueueBindingImpl && b.getClusterName().toString().startsWith(subscriptionName + "_0")) {
                logger.debug("{} = {}", a, b);
                remoteQueueBindings_a2.add((RemoteQueueBinding)b);
            }
        });
        Assertions.assertEquals((int)1, (int)remoteQueueBindings_a2.size());
        AmqpConnection connection = this.createAmqpConnection(new URI("tcp://localhost:5673"));
        this.runAfter(connection::close);
        AmqpSession session2 = connection.createSession();
        AmqpMessage message = new AmqpMessage();
        message.setAddress(TOPIC_NAME);
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.TARGET_QUEUES.toString(), new ArrayList());
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.INTERNAL_ID.toString(), this.a1.getStorageManager().generateID());
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.BROKER_ID.toString(), String.valueOf(this.b1.getNodeID()));
        AmqpSender sender = session2.createSender(this.mirrorName(5673), new Symbol[]{Symbol.getSymbol((String)"amq.mirror")});
        sender.send(message);
        for (int i2 = 0; i2 < 10; ++i2) {
            String name = "my-topic-shared-subscription_" + i2 + ":global";
            Wait.assertEquals((long)0L, () -> ((Queue)this.a1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.b1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.a2.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.b2.locateQueue(name)).getMessageCount());
        }
        message = new AmqpMessage();
        message.setAddress(TOPIC_NAME);
        ArrayList<String> singleQueue = new ArrayList<String>();
        singleQueue.add("my-topic-shared-subscription_3:global");
        singleQueue.add("IDONTEXIST");
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.TARGET_QUEUES.toString(), singleQueue);
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.INTERNAL_ID.toString(), this.a1.getStorageManager().generateID());
        message.setDeliveryAnnotation(AMQPMirrorControllerSource.BROKER_ID.toString(), String.valueOf(this.b1.getNodeID()));
        sender.send(message);
        for (int i3 = 0; i3 < 10; ++i3) {
            String name = "my-topic-shared-subscription_" + i3 + ":global";
            if (i3 == 3) {
                Wait.assertEquals((long)1L, () -> ((Queue)this.a1.locateQueue(name)).getMessageCount());
            } else {
                Wait.assertEquals((long)0L, () -> ((Queue)this.a1.locateQueue(name)).getMessageCount());
            }
            Wait.assertEquals((long)0L, () -> ((Queue)this.b1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.a2.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)0L, () -> ((Queue)this.b2.locateQueue(name)).getMessageCount());
        }
    }

    @Test
    public void testMultiNodeSubscription() throws Exception {
        String name;
        int i;
        int i2;
        Topic topic;
        Session session;
        String protocol = "AMQP";
        String subscriptionName = "my-topic-shared-subscription";
        ConnectionFactory cfA1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        ConnectionFactory cfA2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5674");
        try (Connection conn = cfA1.createConnection();){
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i2 = 0; i2 < 10; ++i2) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i2);
            }
        }
        conn = cfA2.createConnection();
        try {
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            for (i2 = 10; i2 < 20; ++i2) {
                session.createSharedDurableConsumer(topic, subscriptionName + "_" + i2);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Wait.assertTrue(() -> this.a1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.a2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b1.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        Wait.assertTrue(() -> this.b2.getPostOffice().getBindingsForAddress(TOPIC_NAME_SIMPLE_STRING).size() == 20);
        conn = cfA2.createConnection();
        try {
            session = conn.createSession(false, 1);
            topic = session.createTopic(TOPIC_NAME);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)session.createTextMessage("hello"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        for (i = 0; i < 10; ++i) {
            name = "my-topic-shared-subscription_" + i + ":global";
            Wait.waitFor(() -> this.a1.locateQueue(name) != null);
            Wait.waitFor(() -> this.b1.locateQueue(name) != null);
            Wait.assertEquals((long)1L, () -> ((Queue)this.a1.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)1L, () -> ((Queue)this.b1.locateQueue(name)).getMessageCount());
        }
        for (i = 10; i < 20; ++i) {
            name = "my-topic-shared-subscription_" + i + ":global";
            Wait.waitFor(() -> this.a2.locateQueue(name) != null);
            Wait.waitFor(() -> this.b2.locateQueue(name) != null);
            Wait.assertEquals((long)1L, () -> ((Queue)this.a2.locateQueue(name)).getMessageCount());
            Wait.assertEquals((long)1L, () -> ((Queue)this.b2.locateQueue(name)).getMessageCount());
        }
    }

    private void assertEmptyQueue(Queue queue) {
        Assertions.assertNotNull((Object)queue);
        try {
            Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
        }
        catch (Throwable e) {
            if (e instanceof AssertionError) {
                throw (AssertionError)((Object)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }
}

