/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlOnIgnoreLargeMessageBodyTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Topic topic;
    private static int TOTAL_MESSAGES_COUNT = 20000;
    private static int MSG_SIZE = 153600;
    private final int CONSUMERS_COUNT = 5;
    private static final String ATTR_MSG_COUNTER = "msgIdex";
    protected int receiveTimeout = 10000;
    private volatile boolean error = false;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.jmsServer.createTopic(true, "topicIn", new String[]{"/topic/topicIn"});
        this.topic = (Topic)this.namingContext.lookup("/topic/topicIn");
    }

    @Override
    protected boolean usePersistence() {
        return false;
    }

    @Test
    public void testFlowControl() {
        try {
            LoadProducer producer = new LoadProducer("producer", this.topic, this.cf, TOTAL_MESSAGES_COUNT);
            LoadConsumer[] consumers = new LoadConsumer[5];
            CountDownLatch latch = new CountDownLatch(5);
            for (int i = 0; i < consumers.length; ++i) {
                consumers[i] = new LoadConsumer(latch, "consumer " + i, this.topic, this.cf, this.receiveTimeout, TOTAL_MESSAGES_COUNT);
            }
            for (LoadConsumer consumer : consumers) {
                consumer.start();
            }
            FlowControlOnIgnoreLargeMessageBodyTest.waitForLatch(latch);
            producer.start();
            producer.join();
            for (LoadConsumer consumer : consumers) {
                consumer.join();
            }
            String errorMessage = null;
            if (producer.getSentMessages() != TOTAL_MESSAGES_COUNT) {
                errorMessage = "Producer did not send defined count of messages";
            } else {
                for (LoadConsumer consumer : consumers) {
                    if (consumer.getReceivedMessages() == TOTAL_MESSAGES_COUNT) continue;
                    errorMessage = "Consumer did not send defined count of messages";
                    break;
                }
            }
            if (errorMessage != null) {
                System.err.println(errorMessage);
            }
            Assertions.assertFalse((boolean)this.error);
            if (errorMessage != null) {
                Assertions.fail((String)errorMessage);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    class LoadProducer
    extends Thread {
        private final ConnectionFactory cf;
        private final Topic topic;
        private final int messagesCount;
        private volatile boolean requestForStop;
        private volatile boolean stopped;
        private int sentMessages;

        LoadProducer(String name, Topic topic, ConnectionFactory cf, int messagesCount) throws Exception {
            super(name);
            this.requestForStop = false;
            this.stopped = false;
            this.sentMessages = 0;
            this.cf = cf;
            this.topic = topic;
            this.messagesCount = messagesCount;
        }

        public void sendStopRequest() {
            this.stopped = false;
            this.requestForStop = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stopped = false;
            Connection connection = null;
            Session session = null;
            logger.debug("Starting producer for {} - {}", (Object)this.topic, (Object)this.getName());
            try {
                connection = this.cf.createConnection();
                session = connection.createSession(true, 0);
                MessageProducer prod = session.createProducer((Destination)this.topic);
                prod.setDeliveryMode(2);
                for (int i = 1; i <= this.messagesCount && !this.requestForStop && !FlowControlOnIgnoreLargeMessageBodyTest.this.error; ++i) {
                    ++this.sentMessages;
                    BytesMessage msg = session.createBytesMessage();
                    msg.setIntProperty(FlowControlOnIgnoreLargeMessageBodyTest.ATTR_MSG_COUNTER, i);
                    msg.writeBytes(new byte[MSG_SIZE]);
                    prod.send((Message)msg);
                    if (i % 10 == 0) {
                        session.commit();
                    }
                    if (i % 100 != 0) continue;
                    logger.debug("Address {} sent {} messages", (Object)this.topic, (Object)i);
                }
                logger.debug("Ending producer for {} - {} messages {}", new Object[]{this.topic, this.getName(), this.sentMessages});
            }
            catch (Exception e) {
                FlowControlOnIgnoreLargeMessageBodyTest.this.error = true;
                e.printStackTrace();
            }
            finally {
                try {
                    session.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.stopped = true;
        }

        public int getSentMessages() {
            return this.sentMessages;
        }
    }

    class LoadConsumer
    extends Thread {
        private final ConnectionFactory cf;
        private final Topic topic;
        private volatile boolean requestForStop;
        private volatile boolean stopped;
        private volatile int receivedMessages;
        private final int numberOfMessages;
        private int receiveTimeout;
        private final CountDownLatch consumerCreated;

        LoadConsumer(CountDownLatch consumerCreated, String name, Topic topic, ConnectionFactory cf, int receiveTimeout, int numberOfMessages) {
            super(name);
            this.requestForStop = false;
            this.stopped = false;
            this.receivedMessages = 0;
            this.receiveTimeout = 0;
            this.cf = cf;
            this.topic = topic;
            this.receiveTimeout = receiveTimeout;
            this.numberOfMessages = numberOfMessages;
            this.consumerCreated = consumerCreated;
        }

        public void sendStopRequest() {
            this.stopped = false;
            this.requestForStop = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            Session session = null;
            this.stopped = false;
            this.requestForStop = false;
            logger.debug("Starting consumer for {} - {}", (Object)this.topic, (Object)this.getName());
            try {
                connection = this.cf.createConnection();
                connection.setClientID(this.getName());
                connection.start();
                session = connection.createSession(true, 0);
                TopicSubscriber subscriber = session.createDurableSubscriber(this.topic, this.getName());
                this.consumerCreated.countDown();
                int counter = 0;
                while (counter < this.numberOfMessages && !this.requestForStop && !FlowControlOnIgnoreLargeMessageBodyTest.this.error) {
                    BytesMessage msg;
                    if (counter == 0) {
                        logger.debug("Starting to consume for {} - {}", (Object)this.topic, (Object)this.getName());
                    }
                    if ((msg = (BytesMessage)subscriber.receive((long)this.receiveTimeout)) == null) {
                        logger.debug("Cannot get message in specified timeout: {} - {}", (Object)this.topic, (Object)this.getName());
                        FlowControlOnIgnoreLargeMessageBodyTest.this.error = true;
                    } else if (msg.getIntProperty(FlowControlOnIgnoreLargeMessageBodyTest.ATTR_MSG_COUNTER) != ++counter) {
                        FlowControlOnIgnoreLargeMessageBodyTest.this.error = true;
                    }
                    if (counter % 10 == 0) {
                        session.commit();
                    }
                    if (counter % 100 == 0) {
                        logger.debug("## {} {} received {}", new Object[]{this.getName(), this.topic, counter});
                    }
                    this.receivedMessages = counter;
                }
                session.commit();
            }
            catch (Exception e) {
                logger.debug("Exception in consumer {} : {}", (Object)this.getName(), (Object)e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (JMSException e) {
                        System.err.println("Cannot close session " + e.getMessage());
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {
                        System.err.println("Cannot close connection " + e.getMessage());
                    }
                }
            }
            this.stopped = true;
            logger.debug("Stopping consumer for {} - {}, received {}", new Object[]{this.topic, this.getName(), this.getReceivedMessages()});
        }

        public int getReceivedMessages() {
            return this.receivedMessages;
        }
    }
}

