/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionCreateProducerTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    private ClientSessionInternal clientSession;
    private ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        ActiveMQServer service = this.createServer(false);
        service.start();
        this.locator.setProducerMaxRate(99).setBlockOnNonDurableSend(true).setBlockOnNonDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        this.clientSession = (ClientSessionInternal)this.addClientSession(this.cf.createSession(false, true, true));
    }

    @Test
    public void testCreateAnonProducer() throws Exception {
        ClientProducer producer = this.clientSession.createProducer();
        Assertions.assertNull((Object)producer.getAddress());
        Assertions.assertEquals((int)this.cf.getServerLocator().getProducerMaxRate(), (int)producer.getMaxRate());
        Assertions.assertEquals((Object)this.cf.getServerLocator().isBlockOnNonDurableSend(), (Object)producer.isBlockOnNonDurableSend());
        Assertions.assertEquals((Object)this.cf.getServerLocator().isBlockOnDurableSend(), (Object)producer.isBlockOnDurableSend());
        Assertions.assertFalse((boolean)producer.isClosed());
    }

    @Test
    public void testCreateProducer1() throws Exception {
        ClientProducer producer = this.clientSession.createProducer("testAddress");
        Assertions.assertNotNull((Object)producer.getAddress());
        Assertions.assertEquals((int)this.cf.getServerLocator().getProducerMaxRate(), (int)producer.getMaxRate());
        Assertions.assertEquals((Object)this.cf.getServerLocator().isBlockOnNonDurableSend(), (Object)producer.isBlockOnNonDurableSend());
        Assertions.assertEquals((Object)this.cf.getServerLocator().isBlockOnDurableSend(), (Object)producer.isBlockOnDurableSend());
        Assertions.assertFalse((boolean)producer.isClosed());
    }

    @Test
    public void testProducerOnClosedSession() throws Exception {
        this.clientSession.close();
        try {
            this.clientSession.createProducer();
            Assertions.fail((String)"should throw exception");
        }
        catch (ActiveMQObjectClosedException activeMQObjectClosedException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }
}

