/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SessionTest
extends ActiveMQTestBase {
    private boolean legacyCreateQueue;
    private final String queueName = "ClientSessionTestQ";
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Parameters(name="legacyCreateQueue={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({true}, {false});
    }

    public SessionTest(boolean legacyCreateQueue) {
        this.legacyCreateQueue = legacyCreateQueue;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    @TestTemplate
    public void testFailureListener() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(clientSession);
        clientSession.addFailureListener((SessionFailureListener)listener);
        this.server.stop();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
    }

    @TestTemplate
    public void testFailureListenerRemoved() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        try {
            ClientSession clientSession = this.cf.createSession(false, true, true);
            class MyFailureListener
            implements SessionFailureListener {
                boolean called = false;

                MyFailureListener() {
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver) {
                    this.called = true;
                }

                public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                    this.connectionFailed(me, failedOver);
                }

                public void beforeReconnect(ActiveMQException me) {
                }
            }
            MyFailureListener listener = new MyFailureListener();
            clientSession.addFailureListener((SessionFailureListener)listener);
            Assertions.assertTrue((boolean)clientSession.removeFailureListener((SessionFailureListener)listener));
            clientSession.close();
            this.server.stop();
            Assertions.assertFalse((boolean)listener.called);
        }
        finally {
            ((ClientSessionFactoryInternal)this.cf).causeExit();
            this.cf.close();
        }
    }

    @TestTemplate
    public void testCloseSessionOnDestroyedConnection() throws Exception {
        int cons;
        this.server.stop();
        long ttl = 500L;
        this.server.getConfiguration().setConnectionTTLOverride(ttl);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
        ClientSessionInternal clientSession = (ClientSessionInternal)this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = clientSession.createProducer();
        ClientConsumer consumer = clientSession.createConsumer("ClientSessionTestQ");
        Assertions.assertEquals((int)1, (int)this.server.getRemotingService().getConnections().size());
        RemotingConnection rc = clientSession.getConnection();
        rc.fail((ActiveMQException)new ActiveMQInternalErrorException());
        clientSession.close();
        long start = System.currentTimeMillis();
        while ((cons = this.server.getRemotingService().getConnections().size()) != 0) {
            long now = System.currentTimeMillis();
            if (now - start > 10000L) {
                throw new Exception("Timed out waiting for connections to close");
            }
            Thread.sleep(50L);
        }
    }

    @TestTemplate
    public void testBindingQuery() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "q1", false);
            clientSession.createQueue("a1", "q2", false);
            clientSession.createQueue("a2", "q3", false);
            clientSession.createQueue("a2", "q4", false);
            clientSession.createQueue("a2", "q5", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"q1").setAddress("a1").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(QueueConfiguration.of((String)"q2").setAddress("a1").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(QueueConfiguration.of((String)"q3").setAddress("a2").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(QueueConfiguration.of((String)"q4").setAddress("a2").setDurable(Boolean.valueOf(false)));
            clientSession.createQueue(QueueConfiguration.of((String)"q5").setAddress("a2").setDurable(Boolean.valueOf(false)));
        }
        ClientSession.AddressQuery resp = clientSession.addressQuery(SimpleString.of((String)"a"));
        List queues = resp.getQueueNames();
        Assertions.assertTrue((boolean)queues.isEmpty());
        resp = clientSession.addressQuery(SimpleString.of((String)"a1"));
        queues = resp.getQueueNames();
        Assertions.assertEquals((int)queues.size(), (int)2);
        Assertions.assertTrue((boolean)queues.contains(SimpleString.of((String)"q1")));
        Assertions.assertTrue((boolean)queues.contains(SimpleString.of((String)"q2")));
        resp = clientSession.addressQuery(SimpleString.of((String)"a2"));
        queues = resp.getQueueNames();
        Assertions.assertEquals((int)queues.size(), (int)3);
        Assertions.assertTrue((boolean)queues.contains(SimpleString.of((String)"q3")));
        Assertions.assertTrue((boolean)queues.contains(SimpleString.of((String)"q4")));
        Assertions.assertTrue((boolean)queues.contains(SimpleString.of((String)"q5")));
        clientSession.close();
    }

    @TestTemplate
    public void testQueueQuery() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setAddress("a1").setDurable(Boolean.valueOf(false)));
        }
        ClientConsumer consumer1 = clientSession.createConsumer("ClientSessionTestQ");
        ClientConsumer consumer2 = clientSession.createConsumer("ClientSessionTestQ");
        ClientProducer cp = clientSession.createProducer("a1");
        cp.send((Message)clientSession.createMessage(true));
        cp.send((Message)clientSession.createMessage(true));
        Queue queue = this.flushQueue();
        Wait.assertEquals((long)2L, () -> ((Queue)queue).getMessageCount());
        Wait.assertEquals((int)2, () -> ((Queue)queue).getConsumerCount());
        ClientSession.QueueQuery resp = clientSession.queueQuery(SimpleString.of((String)"ClientSessionTestQ"));
        Assertions.assertEquals((Object)SimpleString.of((String)"a1"), (Object)resp.getAddress());
        Assertions.assertEquals((int)2, (int)resp.getConsumerCount());
        Assertions.assertEquals((long)2L, (long)resp.getMessageCount());
        Assertions.assertNull((Object)resp.getFilterString());
        consumer1.close();
        consumer2.close();
        clientSession.close();
    }

    private Queue flushQueue() throws Exception {
        Queue queue = this.server.locateQueue(SimpleString.of((String)"ClientSessionTestQ"));
        Assertions.assertNotNull((Object)queue);
        queue.flushExecutor();
        return queue;
    }

    @TestTemplate
    public void testQueueQueryWithFilter() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("a1", "ClientSessionTestQ", "foo=bar", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setAddress("a1").setFilterString("foo=bar").setDurable(Boolean.valueOf(false)));
        }
        clientSession.createConsumer("ClientSessionTestQ");
        clientSession.createConsumer("ClientSessionTestQ");
        ClientSession.QueueQuery resp = clientSession.queueQuery(SimpleString.of((String)"ClientSessionTestQ"));
        Assertions.assertEquals((Object)SimpleString.of((String)"a1"), (Object)resp.getAddress());
        Assertions.assertEquals((int)2, (int)resp.getConsumerCount());
        Assertions.assertEquals((long)0L, (long)resp.getMessageCount());
        Assertions.assertEquals((Object)SimpleString.of((String)"foo=bar"), (Object)resp.getFilterString());
        clientSession.close();
    }

    @TestTemplate
    public void testQueueQueryNoQ() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)));
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientSession.QueueQuery resp = clientSession.queueQuery(SimpleString.of((String)"ClientSessionTestQ"));
        Assertions.assertFalse((boolean)resp.isExists());
        Assertions.assertFalse((boolean)resp.isAutoCreateQueues());
        Assertions.assertEquals((Object)"ClientSessionTestQ", (Object)resp.getAddress().toString());
        clientSession.close();
    }

    @TestTemplate
    public void testClose() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer p = clientSession.createProducer();
        ClientProducer p1 = clientSession.createProducer("ClientSessionTestQ");
        ClientConsumer c = clientSession.createConsumer("ClientSessionTestQ");
        ClientConsumer c1 = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.close();
        Assertions.assertTrue((boolean)clientSession.isClosed());
        Assertions.assertTrue((boolean)p.isClosed());
        Assertions.assertTrue((boolean)p1.isClosed());
        Assertions.assertTrue((boolean)c.isClosed());
        Assertions.assertTrue((boolean)c1.isClosed());
    }

    @TestTemplate
    public void testCreateMessageNonDurable() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage(false);
        Assertions.assertFalse((boolean)clientMessage.isDurable());
        clientSession.close();
    }

    @TestTemplate
    public void testCreateMessageDurable() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage(true);
        Assertions.assertTrue((boolean)clientMessage.isDurable());
        clientSession.close();
    }

    @TestTemplate
    public void testCreateMessageType() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage((byte)99, false);
        Assertions.assertEquals((byte)99, (byte)clientMessage.getType());
        clientSession.close();
    }

    @TestTemplate
    public void testCreateMessageOverrides() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        ClientMessage clientMessage = clientSession.createMessage((byte)88, false, 100L, 300L, (byte)33);
        Assertions.assertEquals((byte)88, (byte)clientMessage.getType());
        Assertions.assertEquals((long)100L, (long)clientMessage.getExpiration());
        Assertions.assertEquals((long)300L, (long)clientMessage.getTimestamp());
        Assertions.assertEquals((byte)33, (byte)clientMessage.getPriority());
        clientSession.close();
    }

    @TestTemplate
    public void testGetVersion() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        Assertions.assertEquals((int)this.server.getVersion().getIncrementingVersion(), (int)clientSession.getVersion());
        clientSession.close();
    }

    @TestTemplate
    public void testStart() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        clientSession.start();
        clientSession.close();
    }

    @TestTemplate
    public void testStop() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, true, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        clientSession.start();
        clientSession.stop();
        clientSession.close();
    }

    @TestTemplate
    public void testCommitWithSend() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, false, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer cp = clientSession.createProducer("ClientSessionTestQ");
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.commit();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.getMessageCount(q) == 10, (long)2000L, (long)100L));
        clientSession.close();
    }

    @TestTemplate
    public void testRollbackWithSend() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.cf.createSession(false, false, true);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        ClientProducer cp = clientSession.createProducer("ClientSessionTestQ");
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.rollback();
        cp.send((Message)clientSession.createMessage(false));
        cp.send((Message)clientSession.createMessage(false));
        clientSession.commit();
        Wait.assertEquals((int)2, () -> this.getMessageCount(q));
        clientSession.close();
    }

    @TestTemplate
    public void testCommitWithReceive() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = this.cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer("ClientSessionTestQ");
        ClientSession clientSession = this.cf.createSession(false, true, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        ClientConsumer cc = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = cc.receive(5000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        clientSession.commit();
        Assertions.assertNull((Object)cc.receiveImmediate());
        Wait.assertEquals((int)0, () -> this.getMessageCount(q));
        clientSession.close();
        sendSession.close();
    }

    @TestTemplate
    public void testRollbackWithReceive() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true);
        this.cf = this.createSessionFactory(this.locator);
        ClientSession sendSession = this.cf.createSession(false, true, true);
        ClientProducer cp = sendSession.createProducer("ClientSessionTestQ");
        ClientSession clientSession = this.cf.createSession(false, true, false);
        if (this.legacyCreateQueue) {
            clientSession.createQueue("ClientSessionTestQ", "ClientSessionTestQ", false);
        } else {
            clientSession.createQueue(QueueConfiguration.of((String)"ClientSessionTestQ").setDurable(Boolean.valueOf(false)));
        }
        for (int i = 0; i < 10; ++i) {
            cp.send((Message)clientSession.createMessage(false));
        }
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"ClientSessionTestQ")).getBindable();
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        ClientConsumer cc = clientSession.createConsumer("ClientSessionTestQ");
        clientSession.start();
        for (int i = 0; i < 10; ++i) {
            ClientMessage m = cc.receive(5000L);
            Assertions.assertNotNull((Object)m);
            m.acknowledge();
        }
        Wait.assertEquals((int)10, () -> this.getMessageCount(q));
        clientSession.close();
        sendSession.close();
    }

    @TestTemplate
    public void testGetNodeId() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        String nodeId = ((ClientSessionInternal)clientSession).getNodeId();
        Assertions.assertNotNull((Object)nodeId);
    }

    @TestTemplate
    public void testCreateQueue() throws Exception {
        this.cf = this.createSessionFactory(this.locator);
        ClientSession clientSession = this.addClientSession(this.cf.createSession(false, true, true));
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        Queue result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString());
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.of((String)"filter"), true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter"));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter"));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.of((String)"filter"), true, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.of((String)"filter"), true, true, 0, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        Assertions.assertEquals((int)0, (int)result.getMaxConsumers());
        Assertions.assertTrue((boolean)result.isPurgeOnNoConsumers());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true, 0, true);
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        Assertions.assertEquals((int)0, (int)result.getMaxConsumers());
        Assertions.assertTrue((boolean)result.isPurgeOnNoConsumers());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName, RoutingType.ANYCAST, queueName, SimpleString.of((String)"filter"), true, true, 0, true, Boolean.valueOf(true), Boolean.valueOf(true));
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        Assertions.assertEquals((int)0, (int)result.getMaxConsumers());
        Assertions.assertTrue((boolean)result.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)result.isExclusive());
        Assertions.assertTrue((boolean)result.isLastValue());
        this.server.destroyQueue(queueName);
        if (this.legacyCreateQueue) {
            clientSession.createQueue(addressName.toString(), RoutingType.ANYCAST, queueName.toString(), "filter", true, true, 0, true, Boolean.valueOf(true), Boolean.valueOf(true));
        } else {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        }
        result = this.server.locateQueue(queueName);
        Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
        Assertions.assertEquals((Object)queueName, (Object)result.getName());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
        Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
        Assertions.assertTrue((boolean)result.isDurable());
        Assertions.assertTrue((boolean)result.isAutoCreated());
        Assertions.assertEquals((int)0, (int)result.getMaxConsumers());
        Assertions.assertTrue((boolean)result.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)result.isExclusive());
        Assertions.assertTrue((boolean)result.isLastValue());
        Assertions.assertTrue((boolean)result.isEnabled());
        this.server.destroyQueue(queueName);
        if (!this.legacyCreateQueue) {
            clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString("filter").setAutoCreated(Boolean.valueOf(true)).setMaxConsumers(Integer.valueOf(0)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)).setEnabled(Boolean.valueOf(false)));
            result = this.server.locateQueue(queueName);
            Assertions.assertEquals((Object)addressName, (Object)result.getAddress());
            Assertions.assertEquals((Object)queueName, (Object)result.getName());
            Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)result.getRoutingType());
            Assertions.assertEquals((Object)"filter", (Object)result.getFilter().getFilterString().toString());
            Assertions.assertTrue((boolean)result.isDurable());
            Assertions.assertTrue((boolean)result.isAutoCreated());
            Assertions.assertEquals((int)0, (int)result.getMaxConsumers());
            Assertions.assertTrue((boolean)result.isPurgeOnNoConsumers());
            Assertions.assertTrue((boolean)result.isExclusive());
            Assertions.assertTrue((boolean)result.isLastValue());
            Assertions.assertFalse((boolean)result.isEnabled());
            this.server.destroyQueue(queueName);
        }
    }
}

