/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverOnFlowControlTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testOverflowSend() throws Exception {
        ServerLocator locator = this.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setProducerWindowSize(1000).setRetryInterval(100L);
        final ArrayList<ClientSession> sessionList = new ArrayList<ClientSession>();
        Interceptor interceptorClient = new Interceptor(){
            AtomicInteger count = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
                logger.debug("Intercept...{}", (Object)packet.getClass().getName());
                if (packet instanceof SessionProducerCreditsMessage) {
                    SessionProducerCreditsMessage credit = (SessionProducerCreditsMessage)packet;
                    logger.debug("Credits: {}", (Object)credit.getCredits());
                    if (this.count.incrementAndGet() == 2) {
                        logger.debug("### crashing server");
                        try {
                            InVMConnection.setFlushEnabled((boolean)false);
                            FailoverOnFlowControlTest.this.crash(false, (ClientSession)sessionList.get(0));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            InVMConnection.setFlushEnabled((boolean)true);
                        }
                        return false;
                    }
                }
                return true;
            }
        };
        locator.addIncomingInterceptor(interceptorClient);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession session = sf.createSession(true, true);
        sessionList.add(session);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[5000]);
            message.putIntProperty("counter", i);
            producer.send((Message)message);
        }
        session.close();
    }

    @Override
    protected void createConfigs() throws Exception {
        super.createConfigs();
        this.primaryServer.getServer().getConfiguration().setJournalFileSize(0x100000);
        this.backupServer.getServer().getConfiguration().setJournalFileSize(0x100000);
    }

    @Override
    protected ServerLocatorInternal getServerLocator() throws Exception {
        return (ServerLocatorInternal)super.getServerLocator().setMinLargeMessageSize(0x100000).setProducerWindowSize(10240);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }
}

