/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AMQPToOpenwireTest
extends ActiveMQTestBase {
    public static final String OWHOST = "localhost";
    public static final int OWPORT = 61616;
    protected static final String urlString = "tcp://localhost:61616?wireFormat.cacheEnabled=true";
    private ActiveMQServer server;
    protected ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    protected ActiveMQXAConnectionFactory xaFactory = new ActiveMQXAConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    private JmsConnectionFactory qpidfactory;
    protected String queueName = "amqTestQueue1";
    private SimpleString coreQueue;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.getAddressSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")));
        serverConfig.setSecurityEnabled(false);
        this.coreQueue = SimpleString.of((String)this.queueName);
        this.server.createQueue(QueueConfiguration.of((String)this.queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        this.qpidfactory = new JmsConnectionFactory("amqp://localhost:61616");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectMessage() throws Exception {
        try (Connection connection = null;){
            connection = this.qpidfactory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.coreQueue.toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            ArrayList list = new ArrayList();
            list.add("aString");
            ObjectMessage objectMessage = session.createObjectMessage(list);
            producer.send((Message)objectMessage);
            connection.close();
            connection = this.factory.createConnection();
            session = connection.createSession(false, 1);
            queue = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            ObjectMessage receive = (ObjectMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)receive);
            list = (ArrayList)receive.getObject();
            Assertions.assertEquals(list.get(0), (Object)"aString");
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeliveryCountMessage() throws Exception {
        AmqpClient client = new AmqpClient(new URI("tcp://127.0.0.1:61616"), null, null);
        try (AmqpConnection amqpconnection = client.connect();){
            AmqpSession session = amqpconnection.createSession();
            AmqpSender sender = session.createSender(this.queueName);
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("MessageID:0");
            message.getWrappedMessage().setHeader(new Header());
            message.getWrappedMessage().getHeader().setDeliveryCount(new UnsignedInteger(2));
            sender.send(message);
        }
        try (Connection connection = null;){
            connection = this.factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            Message receive = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinaryPropertyConversionToString() throws Exception {
        String binaryPropertyName = "binaryProperty";
        AmqpClient client = new AmqpClient(new URI("tcp://127.0.0.1:61616"), null, null);
        try (AmqpConnection amqpconnection = client.connect();){
            AmqpSession session = amqpconnection.createSession();
            AmqpSender sender = session.createSender(this.queueName);
            AmqpMessage message = new AmqpMessage();
            message.getWrappedMessage().setHeader(new Header());
            message.getWrappedMessage().setApplicationProperties(new ApplicationProperties(Collections.singletonMap("binaryProperty", new Binary("TEST".getBytes()))));
            sender.send(message);
        }
        try (Connection connection = null;){
            connection = this.factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            Message receive = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receive);
            Assertions.assertTrue((boolean)(receive.getObjectProperty("binaryProperty") instanceof String));
        }
    }
}

