/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LargeMessageQueueAutoCreationTest
extends BasicOpenWireTest {
    Queue queue1;
    Random random = new Random();
    ActiveMQConnection testConn;
    ClientSession clientSession;
    @Parameter(index=0)
    public boolean usingCore;

    @Parameters(name="isCore={0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({true}, {false});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        String randomSuffix = new BigInteger(130, this.random).toString(32);
        this.testConn = (ActiveMQConnection)this.coreCf.createConnection();
        this.clientSession = this.testConn.getSessionFactory().createSession();
        this.queue1 = this.createCoreQueue("queue1_" + randomSuffix);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.testConn.close();
        super.tearDown();
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setJournalType(JournalType.NIO);
        Map map = serverConfig.getAddressSettings();
        Map.Entry entry = map.entrySet().iterator().next();
        AddressSettings settings = (AddressSettings)entry.getValue();
        settings.setAutoCreateQueues(Boolean.valueOf(true));
    }

    protected Queue createCoreQueue(String queueName) throws Exception {
        SimpleString address = SimpleString.of((String)queueName);
        this.clientSession.createAddress(address, RoutingType.ANYCAST, false);
        return new ActiveMQQueue(queueName);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testSmallString() throws Exception {
        this.sendStringOfSize(1024);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testHugeString() throws Exception {
        this.sendStringOfSize(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStringOfSize(int msgSize) throws JMSException {
        ConnectionFactory factoryToUse = this.usingCore ? this.coreCf : this.factory;
        try (Connection conn = factoryToUse.createConnection();){
            Session session = conn.createSession(false, 1);
            MessageProducer prod = session.createProducer((Destination)this.queue1);
            TextMessage m = session.createTextMessage();
            m.setJMSDeliveryMode(2);
            StringBuffer buffer = new StringBuffer();
            while (buffer.length() < msgSize) {
                buffer.append(UUIDGenerator.getInstance().generateStringUUID());
            }
            String originalString = buffer.toString();
            m.setText(originalString);
            prod.send((Message)m);
            conn.close();
            conn = factoryToUse.createConnection();
            session = conn.createSession(false, 1);
            MessageConsumer cons = session.createConsumer((Destination)this.queue1);
            conn.start();
            TextMessage rm = (TextMessage)cons.receive(5000L);
            Assertions.assertNotNull((Object)rm);
            String str = rm.getText();
            Assertions.assertEquals((Object)originalString, (Object)str);
        }
    }
}

